/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.http.internal.request;

import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.message.MultiPartPayload;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.message.PartAttributes;
import org.mule.runtime.core.util.AttributeEvaluator;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.core.util.StringUtils;
import org.mule.runtime.core.util.SystemUtils;
import org.mule.runtime.module.http.api.HttpHeaders;
import org.mule.runtime.module.http.api.requester.HttpSendBodyMode;
import org.mule.runtime.module.http.api.requester.HttpStreamingType;
import org.mule.runtime.module.http.internal.HttpParser;
import org.mule.runtime.module.http.internal.domain.ByteArrayHttpEntity;
import org.mule.runtime.module.http.internal.domain.EmptyHttpEntity;
import org.mule.runtime.module.http.internal.domain.HttpEntity;
import org.mule.runtime.module.http.internal.domain.InputStreamHttpEntity;
import org.mule.runtime.module.http.internal.domain.MultipartHttpEntity;
import org.mule.runtime.module.http.internal.domain.request.HttpRequestBuilder;
import org.mule.runtime.module.http.internal.multipart.HttpPartDataSource;
import org.mule.runtime.module.http.internal.request.DefaultHttpRequester;
import org.mule.runtime.module.http.internal.request.HttpRequesterRequestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleEventToHttpRequest {
    private static final Logger logger = LoggerFactory.getLogger(MuleEventToHttpRequest.class);
    private static final List<String> ignoredProperties = Arrays.asList("Connection", "Host", "Transfer-Encoding");
    private static final String APPLICATION_JAVA = "application/java";
    private DefaultHttpRequester requester;
    private MuleContext muleContext;
    private AttributeEvaluator requestStreamingMode;
    private AttributeEvaluator sendBody;

    public MuleEventToHttpRequest(DefaultHttpRequester requester, MuleContext muleContext, AttributeEvaluator requestStreamingMode, AttributeEvaluator sendBody) {
        this.requester = requester;
        this.muleContext = muleContext;
        this.requestStreamingMode = requestStreamingMode;
        this.sendBody = sendBody;
    }

    public HttpRequestBuilder create(Event event, String resolvedMethod, String resolvedUri) throws MessagingException {
        HttpRequesterRequestBuilder requestBuilder = this.requester.getRequestBuilder();
        HttpRequestBuilder builder = new HttpRequestBuilder();
        builder.setUri(resolvedUri);
        builder.setMethod(resolvedMethod);
        builder.setHeaders(requestBuilder.getHeaders(event, this.muleContext));
        builder.setQueryParams(requestBuilder.getQueryParams(event, this.muleContext));
        for (String outboundProperty : event.getMessage().getOutboundPropertyNames()) {
            if (!this.isNotIgnoredProperty(outboundProperty)) continue;
            builder.addHeader(outboundProperty, event.getMessage().getOutboundProperty(outboundProperty).toString());
        }
        DataType dataType = event.getMessage().getPayload().getDataType();
        if (!MediaType.ANY.matches(dataType.getMediaType())) {
            builder.addHeader("Content-Type", dataType.getMediaType().toRfcString());
        }
        if (this.requester.getConfig().isEnableCookies()) {
            try {
                Map<String, List<String>> headers = this.requester.getConfig().getCookieManager().get(URI.create(resolvedUri), Collections.emptyMap());
                List<String> cookies = headers.get("Cookie");
                if (cookies != null) {
                    for (String cookie : cookies) {
                        builder.addHeader("Cookie", cookie);
                    }
                }
            }
            catch (IOException e) {
                logger.warn("Error reading cookies for URI " + resolvedUri, (Throwable)e);
            }
        }
        builder.setEntity(this.createRequestEntity(builder, event, resolvedMethod));
        return builder;
    }

    private boolean isNotIgnoredProperty(String outboundProperty) {
        return !outboundProperty.startsWith("http.") && !this.equalsIgnoredProperty(outboundProperty);
    }

    private boolean equalsIgnoredProperty(String outboundProperty) {
        return CollectionUtils.exists(ignoredProperties, propertyName -> outboundProperty.equalsIgnoreCase((String)propertyName));
    }

    private HttpEntity createRequestEntity(HttpRequestBuilder requestBuilder, Event muleEvent, String resolvedMethod) throws MessagingException {
        if (!StringUtils.isEmpty((String)this.requester.getSource()) && !"#[payload]".equals(this.requester.getSource())) {
            muleEvent = Event.builder((Event)muleEvent).message(InternalMessage.builder((InternalMessage)muleEvent.getMessage()).payload((Object)this.muleContext.getExpressionManager().evaluate(this.requester.getSource(), muleEvent)).build()).build();
        }
        HttpEntity entity = this.isEmptyBody(muleEvent, resolvedMethod) ? new EmptyHttpEntity() : this.createRequestEntityFromPayload(requestBuilder, muleEvent);
        return entity;
    }

    private boolean isEmptyBody(Event event, String method) {
        boolean emptyBody;
        HttpSendBodyMode sendBodyMode = this.resolveSendBodyMode(event);
        if (event.getMessage().getPayload().getValue() == null && event.getMessage().getOutboundAttachmentNames().isEmpty()) {
            emptyBody = true;
        } else {
            emptyBody = DefaultHttpRequester.DEFAULT_EMPTY_BODY_METHODS.contains(method);
            if (sendBodyMode != HttpSendBodyMode.AUTO) {
                emptyBody = sendBodyMode == HttpSendBodyMode.NEVER;
            }
        }
        return emptyBody;
    }

    private HttpEntity createRequestEntityFromPayload(HttpRequestBuilder requestBuilder, Event muleEvent) throws MessagingException {
        Object payload = muleEvent.getMessage().getPayload().getValue();
        if (!muleEvent.getMessage().getOutboundAttachmentNames().isEmpty() || payload instanceof MultiPartPayload) {
            try {
                return this.createMultiPart(muleEvent.getMessage());
            }
            catch (IOException e) {
                throw new MessagingException(muleEvent, (Throwable)e);
            }
        }
        if (this.doStreaming(requestBuilder, muleEvent)) {
            if (payload instanceof InputStream) {
                return new InputStreamHttpEntity((InputStream)payload);
            }
            try {
                return new InputStreamHttpEntity(new ByteArrayInputStream(muleEvent.getMessageAsBytes(this.muleContext)));
            }
            catch (Exception e) {
                throw new MessagingException(muleEvent, (Throwable)e);
            }
        }
        String contentType = requestBuilder.getHeaders().get((Object)"Content-Type");
        if ((contentType == null || contentType.startsWith(HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED.toRfcString()) || contentType.startsWith(APPLICATION_JAVA)) && muleEvent.getMessage().getPayload().getValue() instanceof Map) {
            String body = HttpParser.encodeString(muleEvent.getMessage().getPayload().getDataType().getMediaType().getCharset().orElse(SystemUtils.getDefaultEncoding((MuleContext)this.muleContext)), (Map)payload);
            requestBuilder.addHeader("Content-Type", HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED.toRfcString());
            return new ByteArrayHttpEntity(body.getBytes());
        }
        try {
            return new ByteArrayHttpEntity(muleEvent.getMessageAsBytes(this.muleContext));
        }
        catch (Exception e) {
            throw new MessagingException(muleEvent, (Throwable)e);
        }
    }

    protected MultipartHttpEntity createMultiPart(InternalMessage msg) throws IOException {
        HashMap attachments = Maps.newHashMap();
        for (String outboundAttachmentName : msg.getOutboundAttachmentNames()) {
            attachments.put(outboundAttachmentName, msg.getOutboundAttachment(outboundAttachmentName));
        }
        if (msg.getPayload().getValue() instanceof MultiPartPayload) {
            for (Message part : ((MultiPartPayload)msg.getPayload().getValue()).getParts()) {
                String partName = ((PartAttributes)part.getAttributes()).getName();
                attachments.put(partName, IOUtils.toDataHandler((String)partName, (Object)part.getPayload().getValue(), (MediaType)part.getPayload().getDataType().getMediaType()));
            }
        }
        return new MultipartHttpEntity(HttpPartDataSource.createFrom(attachments));
    }

    private boolean doStreaming(HttpRequestBuilder requestBuilder, Event event) throws MessagingException {
        String transferEncodingHeader = requestBuilder.getHeaders().get((Object)"Transfer-Encoding");
        String contentLengthHeader = requestBuilder.getHeaders().get((Object)"Content-Length");
        HttpStreamingType requestStreamingMode = this.resolveStreamingType(event);
        Object payload = event.getMessage().getPayload().getValue();
        if (requestStreamingMode == HttpStreamingType.AUTO) {
            if (contentLengthHeader != null) {
                if (transferEncodingHeader != null) {
                    requestBuilder.removeHeader("Transfer-Encoding");
                    if (logger.isDebugEnabled()) {
                        logger.debug("Cannot send both Transfer-Encoding and Content-Length headers. Transfer-Encoding will not be sent.");
                    }
                }
                return false;
            }
            if (transferEncodingHeader == null || !transferEncodingHeader.equalsIgnoreCase("chunked")) {
                return payload instanceof InputStream;
            }
            return true;
        }
        if (requestStreamingMode == HttpStreamingType.ALWAYS) {
            if (contentLengthHeader != null) {
                requestBuilder.removeHeader("Content-Length");
                if (logger.isDebugEnabled()) {
                    logger.debug("Content-Length header will not be sent, as the configured requestStreamingMode is ALWAYS");
                }
            }
            if (transferEncodingHeader != null && !transferEncodingHeader.equalsIgnoreCase("chunked")) {
                requestBuilder.removeHeader("Transfer-Encoding");
                if (logger.isDebugEnabled()) {
                    logger.debug("Transfer-Encoding header will be sent with value 'chunked' instead of {}, as the configured requestStreamingMode is NEVER", (Object)transferEncodingHeader);
                }
            }
            return true;
        }
        if (transferEncodingHeader != null) {
            requestBuilder.removeHeader("Transfer-Encoding");
            if (logger.isDebugEnabled()) {
                logger.debug("Transfer-Encoding header will not be sent, as the configured requestStreamingMode is NEVER");
            }
        }
        return false;
    }

    private HttpStreamingType resolveStreamingType(Event event) {
        return HttpStreamingType.valueOf(this.requestStreamingMode.resolveStringValue(event));
    }

    private HttpSendBodyMode resolveSendBodyMode(Event event) {
        return HttpSendBodyMode.valueOf(this.sendBody.resolveStringValue(event));
    }
}

