/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.http.internal.multipart;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Part;

public class HttpPart
implements Part {
    public static final int NO_SIZE = -1;
    private final byte[] content;
    private final String contentType;
    private final String partName;
    private final String fileName;
    private final int size;
    private Map<String, Object> headers = new HashMap<String, Object>();

    public HttpPart(String partName, byte[] content, String contentType, int size) {
        this(partName, null, content, contentType, size);
    }

    public HttpPart(String partName, String fileName, byte[] content, String contentType, int size) {
        this.partName = partName;
        this.fileName = fileName;
        this.content = content;
        this.contentType = contentType;
        this.size = size;
    }

    public void delete() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getHeader(String headerName) {
        return (String)this.headers.get(headerName);
    }

    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public Collection<String> getHeaders(String headerName) {
        Object headerValue = this.headers.get(headerName);
        if (headerValue instanceof Collection) {
            return (Collection)headerValue;
        }
        return Lists.newArrayList((Object[])new String[]{(String)headerValue});
    }

    public void addHeader(String headerName, String headerValue) {
        Object value = this.headers.get(headerName);
        if (value == null) {
            this.headers.put(headerName, headerValue);
        } else if (value instanceof Collection) {
            ((Collection)value).add(headerValue);
        } else {
            ArrayList<String> values = new ArrayList<String>();
            values.add((String)value);
            values.add(headerValue);
            this.headers.put(headerName, values);
        }
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.content);
    }

    public String getName() {
        return this.partName;
    }

    public long getSize() {
        return this.size;
    }

    public void write(String fileName) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getFileName() {
        return this.fileName;
    }
}

