/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.http.internal.listener.matcher;

import org.mule.runtime.module.http.internal.domain.request.HttpRequest;
import org.mule.runtime.module.http.internal.listener.matcher.MethodRequestMatcher;
import org.mule.runtime.module.http.internal.listener.matcher.RequestMatcher;

public class ListenerRequestMatcher
implements RequestMatcher {
    private String path;
    private final MethodRequestMatcher methodRequestMatcher;

    public ListenerRequestMatcher(MethodRequestMatcher methodRequestMatcher, String path) {
        this.methodRequestMatcher = methodRequestMatcher;
        this.path = path;
        if (this.doesNotEndWithWildcardPath()) {
            this.path = this.path + "/";
        }
    }

    private boolean doesNotEndWithWildcardPath() {
        return !this.path.endsWith("/") && !this.path.endsWith("*");
    }

    public String getPath() {
        return this.path;
    }

    public MethodRequestMatcher getMethodRequestMatcher() {
        return this.methodRequestMatcher;
    }

    @Override
    public boolean matches(HttpRequest request) {
        return this.methodRequestMatcher.matches(request);
    }

    public String toString() {
        return "ListenerRequestMatcher{path='" + this.path + '\'' + ", methodRequestMatcher=" + this.methodRequestMatcher + '}';
    }
}

