/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.http.internal.listener.grizzly;

import java.io.IOException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.ssl.SSLConnectionContext;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.mule.runtime.module.http.api.HttpConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleSslFilter
extends SSLFilter {
    public static final String SSL_SESSION_ATTRIBUTE_KEY = "muleSslSession";
    private static final Logger logger = LoggerFactory.getLogger(MuleSslFilter.class);

    public MuleSslFilter(SSLEngineConfigurator serverSSLEngineConfigurator, SSLEngineConfigurator clientSSLEngineConfigurator) {
        super(serverSSLEngineConfigurator, clientSSLEngineConfigurator);
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        try {
            ctx.getAttributes().setAttribute(HttpConstants.Protocols.HTTPS.getScheme(), (Object)true);
            NextAction nextAction = super.handleRead(ctx);
            ctx.getAttributes().setAttribute(SSL_SESSION_ATTRIBUTE_KEY, (Object)this.getSslSession(ctx));
            return nextAction;
        }
        catch (SSLHandshakeException e) {
            logger.error("SSL handshake error: " + e.getMessage());
            throw e;
        }
    }

    private SSLSession getSslSession(FilterChainContext ctx) throws SSLPeerUnverifiedException {
        SSLConnectionContext sslConnectionContext = this.obtainSslConnectionContext(ctx.getConnection());
        if (sslConnectionContext == null) {
            return null;
        }
        return sslConnectionContext.getSslEngine().getSession();
    }
}

