/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.http.internal.listener.grizzly;

import java.io.IOException;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.nio.transport.TCPNIOServerConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.mule.runtime.module.http.internal.listener.HttpListenerRegistry;
import org.mule.runtime.module.http.internal.listener.RequestHandlerManager;
import org.mule.runtime.module.http.internal.listener.Server;
import org.mule.runtime.module.http.internal.listener.ServerAddress;
import org.mule.runtime.module.http.internal.listener.async.RequestHandler;
import org.mule.runtime.module.http.internal.listener.matcher.ListenerRequestMatcher;

public class GrizzlyServer
implements Server {
    private final TCPNIOTransport transport;
    private final ServerAddress serverAddress;
    private final HttpListenerRegistry listenerRegistry;
    private TCPNIOServerConnection serverConnection;
    private boolean stopped = true;
    private boolean stopping;

    public GrizzlyServer(ServerAddress serverAddress, TCPNIOTransport transport, HttpListenerRegistry listenerRegistry) {
        this.serverAddress = serverAddress;
        this.transport = transport;
        this.listenerRegistry = listenerRegistry;
    }

    @Override
    public synchronized void start() throws IOException {
        this.serverConnection = this.transport.bind(this.serverAddress.getIp(), this.serverAddress.getPort());
        this.stopped = false;
    }

    @Override
    public synchronized void stop() {
        this.stopping = true;
        try {
            this.transport.unbind((Connection)this.serverConnection);
        }
        finally {
            this.stopping = false;
        }
    }

    @Override
    public ServerAddress getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public boolean isStopping() {
        return this.stopping;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public RequestHandlerManager addRequestHandler(ListenerRequestMatcher listenerRequestMatcher, RequestHandler requestHandler) {
        return this.listenerRegistry.addRequestHandler(this, requestHandler, listenerRequestMatcher);
    }
}

