/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.http.internal.listener;

public class ServerAddress {
    private final String ip;
    private int port;

    public ServerAddress(String ip, int port) {
        this.port = port;
        this.ip = ip;
    }

    public int getPort() {
        return this.port;
    }

    public String getIp() {
        return this.ip;
    }

    public boolean overlaps(ServerAddress serverAddress) {
        return this.port == serverAddress.getPort() && (this.isAllInterfaces() || serverAddress.isAllInterfaces());
    }

    public boolean isAllInterfaces() {
        return this.ip.equals("0.0.0.0");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerAddress that = (ServerAddress)o;
        if (this.port != that.port) {
            return false;
        }
        return this.ip.equals(that.ip);
    }

    public int hashCode() {
        int result = this.ip.hashCode();
        result = 31 * result + this.port;
        return result;
    }

    public String toString() {
        return "ServerAddress{ip='" + this.ip + '\'' + ", port=" + this.port + '}';
    }
}

