/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.http.internal.listener;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.message.MultiPartPayload;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.message.PartAttributes;
import org.mule.runtime.core.model.ParameterMap;
import org.mule.runtime.core.util.AttributeEvaluator;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.core.util.NumberUtils;
import org.mule.runtime.core.util.UUID;
import org.mule.runtime.module.http.api.HttpConstants;
import org.mule.runtime.module.http.api.HttpHeaders;
import org.mule.runtime.module.http.api.requester.HttpStreamingType;
import org.mule.runtime.module.http.internal.HttpMessageBuilder;
import org.mule.runtime.module.http.internal.HttpParamType;
import org.mule.runtime.module.http.internal.HttpParser;
import org.mule.runtime.module.http.internal.domain.ByteArrayHttpEntity;
import org.mule.runtime.module.http.internal.domain.EmptyHttpEntity;
import org.mule.runtime.module.http.internal.domain.HttpEntity;
import org.mule.runtime.module.http.internal.domain.HttpProtocol;
import org.mule.runtime.module.http.internal.domain.InputStreamHttpEntity;
import org.mule.runtime.module.http.internal.domain.MultipartHttpEntity;
import org.mule.runtime.module.http.internal.domain.response.HttpResponse;
import org.mule.runtime.module.http.internal.listener.HttpResponseHeaderBuilder;
import org.mule.runtime.module.http.internal.multipart.HttpMultipartEncoder;
import org.mule.runtime.module.http.internal.multipart.HttpPartDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseBuilder
extends HttpMessageBuilder
implements Initialisable,
MuleContextAware {
    public static final String MULTIPART = "multipart";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String statusCode;
    private String reasonPhrase;
    private boolean disablePropertiesAsHeaders = false;
    private HttpStreamingType responseStreaming = HttpStreamingType.AUTO;
    private boolean multipartEntityWithNoMultipartContentyTypeWarned;
    private boolean mapPayloadButNoUrlEncodedContentyTypeWarned;
    private AttributeEvaluator statusCodeEvaluator;
    private AttributeEvaluator reasonPhraseEvaluator;
    private MuleContext muleContext;

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        this.init();
    }

    void init() throws InitialisationException {
        this.statusCodeEvaluator = new AttributeEvaluator(this.statusCode).initialize(this.muleContext.getExpressionManager());
        this.reasonPhraseEvaluator = new AttributeEvaluator(this.reasonPhrase).initialize(this.muleContext.getExpressionManager());
    }

    public HttpResponse build(org.mule.runtime.module.http.internal.domain.response.HttpResponseBuilder httpResponseBuilder, Event event) throws MessagingException {
        String resolvedReasonPhrase;
        HttpEntity httpEntity;
        DataType dataType;
        HttpResponseHeaderBuilder httpResponseHeaderBuilder = new HttpResponseHeaderBuilder();
        Set outboundProperties = event.getMessage().getOutboundPropertyNames();
        if (!this.disablePropertiesAsHeaders) {
            for (String outboundPropertyName : outboundProperties) {
                if (!this.isNotIgnoredProperty(outboundPropertyName)) continue;
                Serializable outboundPropertyValue = event.getMessage().getOutboundProperty(outboundPropertyName);
                httpResponseHeaderBuilder.addHeader(outboundPropertyName, outboundPropertyValue);
            }
        }
        if (!MediaType.ANY.matches((dataType = event.getMessage().getPayload().getDataType()).getMediaType())) {
            httpResponseHeaderBuilder.addHeader("Content-Type", dataType.getMediaType().toRfcString());
        }
        ParameterMap resolvedHeaders = this.resolveParams(event, HttpParamType.HEADER, this.muleContext);
        for (String name : resolvedHeaders.keySet()) {
            List paramValues = resolvedHeaders.getAll(name);
            for (String value : paramValues) {
                if ("Transfer-Encoding".equals(name) && !this.supportsTransferEncoding(event)) {
                    this.logger.debug("Client HTTP version is lower than 1.1 so the unsupported 'Transfer-Encoding' header has been removed and 'Content-Length' will be sent instead.");
                    continue;
                }
                httpResponseHeaderBuilder.addHeader(name, value);
            }
        }
        String configuredContentType = httpResponseHeaderBuilder.getContentType();
        String existingTransferEncoding = httpResponseHeaderBuilder.getTransferEncoding();
        String existingContentLength = httpResponseHeaderBuilder.getContentLength();
        if (!event.getMessage().getOutboundAttachmentNames().isEmpty() || event.getMessage().getPayload().getValue() instanceof MultiPartPayload) {
            if (configuredContentType == null) {
                httpResponseHeaderBuilder.addContentType(this.createMultipartFormDataContentType());
            } else if (!configuredContentType.startsWith(MULTIPART)) {
                this.warnNoMultipartContentTypeButMultipartEntity(httpResponseHeaderBuilder.getContentType());
            }
            httpEntity = this.createMultipartEntity(event, httpResponseHeaderBuilder.getContentType());
            this.resolveEncoding(httpResponseHeaderBuilder, existingTransferEncoding, existingContentLength, this.supportsTransferEncoding(event), (ByteArrayHttpEntity)httpEntity);
        } else {
            ByteArrayHttpEntity byteArrayHttpEntity;
            Object payload = event.getMessage().getPayload().getValue();
            if (payload == null) {
                this.setupContentLengthEncoding(httpResponseHeaderBuilder, 0);
                httpEntity = new EmptyHttpEntity();
            } else if (payload instanceof Map) {
                if (configuredContentType == null) {
                    httpResponseHeaderBuilder.addContentType(HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED.toRfcString());
                } else if (!configuredContentType.startsWith(HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED.toRfcString())) {
                    this.warnMapPayloadButNoUrlEncodedContentType(httpResponseHeaderBuilder.getContentType());
                }
                httpEntity = this.createUrlEncodedEntity(event, (Map)payload);
                if (this.responseStreaming == HttpStreamingType.ALWAYS && this.supportsTransferEncoding(event)) {
                    this.setupChunkedEncoding(httpResponseHeaderBuilder);
                } else if (httpEntity instanceof EmptyHttpEntity) {
                    this.setupContentLengthEncoding(httpResponseHeaderBuilder, 0);
                } else {
                    byteArrayHttpEntity = (ByteArrayHttpEntity)httpEntity;
                    this.setupContentLengthEncoding(httpResponseHeaderBuilder, byteArrayHttpEntity.getContent().length);
                }
            } else if (payload instanceof InputStream) {
                if (this.responseStreaming == HttpStreamingType.ALWAYS || this.responseStreaming == HttpStreamingType.AUTO && existingContentLength == null) {
                    if (this.supportsTransferEncoding(event)) {
                        this.setupChunkedEncoding(httpResponseHeaderBuilder);
                    }
                    httpEntity = new InputStreamHttpEntity((InputStream)payload);
                } else {
                    byteArrayHttpEntity = new ByteArrayHttpEntity(IOUtils.toByteArray((InputStream)((InputStream)payload)));
                    this.setupContentLengthEncoding(httpResponseHeaderBuilder, byteArrayHttpEntity.getContent().length);
                    httpEntity = byteArrayHttpEntity;
                }
            } else {
                try {
                    byteArrayHttpEntity = new ByteArrayHttpEntity(event.getMessageAsBytes(this.muleContext));
                    this.resolveEncoding(httpResponseHeaderBuilder, existingTransferEncoding, existingContentLength, this.supportsTransferEncoding(event), byteArrayHttpEntity);
                    httpEntity = byteArrayHttpEntity;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        Collection<String> headerNames = httpResponseHeaderBuilder.getHeaderNames();
        for (String headerName : headerNames) {
            Collection<String> values = httpResponseHeaderBuilder.getHeader(headerName);
            for (String value : values) {
                httpResponseBuilder.addHeader(headerName, value);
            }
        }
        Integer resolvedStatusCode = this.resolveStatusCode(event);
        if (resolvedStatusCode != null) {
            httpResponseBuilder.setStatusCode(resolvedStatusCode);
        }
        if ((resolvedReasonPhrase = this.resolveReasonPhrase(event, resolvedStatusCode)) != null) {
            httpResponseBuilder.setReasonPhrase(resolvedReasonPhrase);
        }
        httpResponseBuilder.setEntity(httpEntity);
        return httpResponseBuilder.build();
    }

    private boolean supportsTransferEncoding(Event event) {
        String httpVersion = (String)((Object)event.getMessage().getInboundProperty("http.version"));
        return !HttpProtocol.HTTP_0_9.asString().equals(httpVersion) && !HttpProtocol.HTTP_1_0.asString().equals(httpVersion);
    }

    private void resolveEncoding(HttpResponseHeaderBuilder httpResponseHeaderBuilder, String existingTransferEncoding, String existingContentLength, boolean supportsTranferEncoding, ByteArrayHttpEntity byteArrayHttpEntity) {
        if (this.responseStreaming == HttpStreamingType.ALWAYS || this.responseStreaming == HttpStreamingType.AUTO && existingContentLength == null && "chunked".equals(existingTransferEncoding)) {
            if (supportsTranferEncoding) {
                this.setupChunkedEncoding(httpResponseHeaderBuilder);
            }
        } else {
            this.setupContentLengthEncoding(httpResponseHeaderBuilder, byteArrayHttpEntity.getContent().length);
        }
    }

    private boolean isNotIgnoredProperty(String outboundPropertyName) {
        return !outboundPropertyName.startsWith("http.") && !outboundPropertyName.equalsIgnoreCase("Connection") && !outboundPropertyName.equalsIgnoreCase("Transfer-Encoding");
    }

    private void setupContentLengthEncoding(HttpResponseHeaderBuilder httpResponseHeaderBuilder, int contentLength) {
        if (httpResponseHeaderBuilder.getTransferEncoding() != null) {
            this.logger.debug("Content-Length encoding is being used so the 'Transfer-Encoding' header has been removed");
            httpResponseHeaderBuilder.removeHeader("Transfer-Encoding");
        }
        httpResponseHeaderBuilder.setContentLenght(String.valueOf(contentLength));
    }

    private void setupChunkedEncoding(HttpResponseHeaderBuilder httpResponseHeaderBuilder) {
        if (httpResponseHeaderBuilder.getContentLength() != null) {
            this.logger.debug("Chunked encoding is being used so the 'Content-Length' header has been removed");
            httpResponseHeaderBuilder.removeHeader("Content-Length");
        }
        httpResponseHeaderBuilder.addHeader("Transfer-Encoding", "chunked");
    }

    private Integer resolveStatusCode(Event event) {
        if (this.statusCode != null) {
            return this.statusCodeEvaluator.resolveIntegerValue(event);
        }
        Serializable statusCodeOutboundProperty = event.getMessage().getOutboundProperty("http.status");
        if (statusCodeOutboundProperty != null) {
            return NumberUtils.toInt((Object)statusCodeOutboundProperty);
        }
        return null;
    }

    private String resolveReasonPhrase(Event event, Integer resolvedStatusCode) {
        if (this.reasonPhrase != null) {
            return this.reasonPhraseEvaluator.resolveStringValue(event);
        }
        Serializable reasonPhraseOutboundProperty = event.getMessage().getOutboundProperty("http.reason");
        if (reasonPhraseOutboundProperty != null) {
            return reasonPhraseOutboundProperty.toString();
        }
        if (resolvedStatusCode != null) {
            return HttpConstants.HttpStatus.getReasonPhraseForStatusCode(resolvedStatusCode);
        }
        return null;
    }

    private String createMultipartFormDataContentType() {
        return String.format("%s; boundary=%s", "multipart/form-data", UUID.getUUID());
    }

    private HttpEntity createUrlEncodedEntity(Event event, Map payload) {
        Map mapPayload = payload;
        HttpEntity entity = new EmptyHttpEntity();
        if (!mapPayload.isEmpty()) {
            Charset encoding = (Charset)event.getMessage().getPayload().getDataType().getMediaType().getCharset().get();
            String encodedBody = mapPayload instanceof ParameterMap ? HttpParser.encodeString(encoding, ((ParameterMap)mapPayload).toListValuesMap()) : HttpParser.encodeString(encoding, mapPayload);
            entity = new ByteArrayHttpEntity(encodedBody.getBytes());
        }
        return entity;
    }

    private void warnMapPayloadButNoUrlEncodedContentType(String contentType) {
        if (!this.mapPayloadButNoUrlEncodedContentyTypeWarned) {
            this.logger.warn(String.format("Payload is a Map which will be used to generate an url encoded http body but Contenty-Type specified is %s and not %s", contentType, HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED));
            this.mapPayloadButNoUrlEncodedContentyTypeWarned = true;
        }
    }

    private void warnNoMultipartContentTypeButMultipartEntity(String contentType) {
        if (!this.multipartEntityWithNoMultipartContentyTypeWarned) {
            this.logger.warn(String.format("Sending http response with Content-Type %s but the message has attachment and a multipart entity is generated", contentType));
            this.multipartEntityWithNoMultipartContentyTypeWarned = true;
        }
    }

    private HttpEntity createMultipartEntity(Event event, String contentType) throws MessagingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Message contains outbound attachments. Ignoring payload and trying to generate multipart response");
        }
        HashMap<String, DataHandler> parts = new HashMap<String, DataHandler>();
        for (String outboundAttachmentName : event.getMessage().getOutboundAttachmentNames()) {
            parts.put(outboundAttachmentName, event.getMessage().getOutboundAttachment(outboundAttachmentName));
        }
        try {
            if (event.getMessage().getPayload().getValue() instanceof MultiPartPayload) {
                for (Message part : ((MultiPartPayload)event.getMessage().getPayload().getValue()).getParts()) {
                    String partName = ((PartAttributes)part.getAttributes()).getName();
                    parts.put(partName, IOUtils.toDataHandler((String)partName, (Object)part.getPayload().getValue(), (MediaType)part.getPayload().getDataType().getMediaType()));
                }
            }
            MultipartHttpEntity multipartEntity = new MultipartHttpEntity(HttpPartDataSource.createFrom(parts));
            return new ByteArrayHttpEntity(HttpMultipartEncoder.createMultipartContent(multipartEntity, contentType));
        }
        catch (Exception e) {
            throw new MessagingException(event, (Throwable)e);
        }
    }

    public static HttpResponseBuilder emptyInstance(MuleContext muleContext) throws InitialisationException {
        HttpResponseBuilder httpResponseBuilder = new HttpResponseBuilder();
        httpResponseBuilder.setMuleContext(muleContext);
        httpResponseBuilder.init();
        return httpResponseBuilder;
    }

    public void setReasonPhrase(String reasonPhrase) {
        this.reasonPhrase = reasonPhrase;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public void setDisablePropertiesAsHeaders(boolean disablePropertiesAsHeaders) {
        this.disablePropertiesAsHeaders = disablePropertiesAsHeaders;
    }

    public void setResponseStreaming(HttpStreamingType responseStreaming) {
        this.responseStreaming = responseStreaming;
    }

    public HttpStreamingType getResponseStreaming() {
        return this.responseStreaming;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }
}

