/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.http.internal.listener;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.module.http.api.HttpHeaders;
import org.mule.runtime.module.http.internal.HttpParser;
import org.mule.runtime.module.http.internal.domain.EmptyHttpEntity;
import org.mule.runtime.module.http.internal.domain.HttpEntity;
import org.mule.runtime.module.http.internal.domain.InputStreamHttpEntity;
import org.mule.runtime.module.http.internal.domain.MultipartHttpEntity;
import org.mule.runtime.module.http.internal.domain.request.HttpRequest;
import org.mule.runtime.module.http.internal.domain.request.HttpRequestContext;
import org.mule.runtime.module.http.internal.listener.HttpMessagePropertiesResolver;
import org.mule.runtime.module.http.internal.listener.HttpRequestParsingException;
import org.mule.runtime.module.http.internal.listener.ListenerPath;
import org.mule.runtime.module.http.internal.multipart.HttpPartDataSource;
import org.mule.runtime.module.http.internal.util.HttpToMuleMessage;

public class HttpRequestToMuleEvent {
    public static InternalMessage transform(HttpRequestContext requestContext, Charset charset, Boolean parseRequest, ListenerPath listenerPath) throws HttpRequestParsingException {
        HttpRequest request = requestContext.getRequest();
        Collection<String> headerNames = request.getHeaderNames();
        HashMap<String, Serializable> inboundProperties = new HashMap<String, Serializable>();
        HashMap outboundProperties = new HashMap();
        for (String headerName : headerNames) {
            if ("Content-Type".equalsIgnoreCase(headerName)) continue;
            Collection<String> values = request.getHeaderValues(headerName);
            if (values.size() == 1) {
                inboundProperties.put(headerName, (Serializable)((Object)values.iterator().next()));
                continue;
            }
            inboundProperties.put(headerName, new ArrayList<String>(values));
        }
        new HttpMessagePropertiesResolver().setMethod(request.getMethod()).setProtocol(request.getProtocol().asString()).setUri(request.getUri()).setListenerPath(listenerPath).setRemoteHostAddress(HttpRequestToMuleEvent.resolveRemoteHostAddress(requestContext)).setScheme(requestContext.getScheme()).setClientCertificate(requestContext.getClientConnection().getClientCertificate()).addPropertiesTo(inboundProperties);
        InputStream payload = null;
        MediaType mediaType = HttpToMuleMessage.getMediaType(request.getHeaderValueIgnoreCase("Content-Type"), charset);
        if (parseRequest.booleanValue()) {
            HttpEntity entity = request.getEntity();
            if (entity != null && !(entity instanceof EmptyHttpEntity)) {
                if (entity instanceof MultipartHttpEntity) {
                    try {
                        payload = HttpPartDataSource.multiPartPayloadForAttachments((MultipartHttpEntity)entity);
                    }
                    catch (IOException e) {
                        throw new HttpRequestParsingException(e.getMessage(), e);
                    }
                } else if (mediaType != null) {
                    if (mediaType.matches(HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED)) {
                        try {
                            payload = HttpParser.decodeUrlEncodedBody(IOUtils.toString((InputStream)((InputStreamHttpEntity)entity).getInputStream()), (Charset)mediaType.getCharset().get());
                        }
                        catch (IllegalArgumentException e) {
                            throw new HttpRequestParsingException("Cannot decode x-www-form-urlencoded payload", e);
                        }
                    } else if (entity instanceof InputStreamHttpEntity) {
                        payload = ((InputStreamHttpEntity)entity).getInputStream();
                    }
                } else if (entity instanceof InputStreamHttpEntity) {
                    payload = ((InputStreamHttpEntity)entity).getInputStream();
                }
            }
        } else {
            InputStreamHttpEntity inputStreamEntity = request.getInputStreamEntity();
            if (inputStreamEntity != null) {
                payload = inputStreamEntity.getInputStream();
            }
        }
        InternalMessage message = InternalMessage.builder().payload((Object)payload).mediaType(mediaType).inboundProperties(inboundProperties).outboundProperties(outboundProperties).build();
        return message;
    }

    private static String resolveRemoteHostAddress(HttpRequestContext requestContext) {
        return requestContext.getClientConnection().getRemoteHostAddress().toString();
    }
}

