/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.http.internal.listener;

import java.io.Serializable;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.core.model.ParameterMap;
import org.mule.runtime.module.http.internal.HttpParser;
import org.mule.runtime.module.http.internal.listener.ListenerPath;

public class HttpMessagePropertiesResolver {
    private String uri;
    private String method;
    private String protocol;
    private String remoteHostAddress;
    private ListenerPath listenerPath;
    private String scheme;
    private Certificate clientCertificate;

    public HttpMessagePropertiesResolver setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public HttpMessagePropertiesResolver setMethod(String method) {
        this.method = method;
        return this;
    }

    public HttpMessagePropertiesResolver setProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public HttpMessagePropertiesResolver setRemoteHostAddress(String remoteHostAddress) {
        this.remoteHostAddress = remoteHostAddress;
        return this;
    }

    public HttpMessagePropertiesResolver setListenerPath(ListenerPath listenerPath) {
        this.listenerPath = listenerPath;
        return this;
    }

    public HttpMessagePropertiesResolver setScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public HttpMessagePropertiesResolver setClientCertificate(Certificate clientCertificate) {
        this.clientCertificate = clientCertificate;
        return this;
    }

    public void addPropertiesTo(Map<String, Serializable> propertiesMap) {
        String resolvedListenerPath = this.listenerPath.getResolvedPath();
        propertiesMap.put("http.method", (Serializable)((Object)this.method));
        String path = HttpParser.extractPath(this.uri);
        String rawQueryString = HttpParser.extractQueryParams(this.uri);
        ParameterMap queryParams = HttpParser.decodeQueryString(rawQueryString);
        propertiesMap.put("http.query.params", queryParams == null ? new HashMap() : queryParams.toImmutableParameterMap());
        propertiesMap.put("http.query.string", (Serializable)((Object)rawQueryString));
        propertiesMap.put("http.request.path", (Serializable)((Object)path));
        propertiesMap.put("http.version", (Serializable)((Object)this.protocol));
        propertiesMap.put("http.request.uri", (Serializable)((Object)this.uri));
        propertiesMap.put("http.remote.address", (Serializable)((Object)this.remoteHostAddress));
        propertiesMap.put("http.uri.params", (Serializable)HttpParser.decodeUriParams(resolvedListenerPath, path));
        propertiesMap.put("http.listener.path", (Serializable)((Object)resolvedListenerPath));
        propertiesMap.put("http.relative.path", (Serializable)((Object)this.listenerPath.getRelativePath(path)));
        propertiesMap.put("http.scheme", (Serializable)((Object)this.scheme));
        if (this.clientCertificate != null) {
            propertiesMap.put("http.client.cert", this.clientCertificate);
        }
    }
}

