/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.http.internal.listener;

import java.io.ByteArrayInputStream;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.config.ExceptionHelper;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.execution.AsyncResponseFlowProcessingPhaseTemplate;
import org.mule.runtime.core.execution.ResponseCompletionCallback;
import org.mule.runtime.core.execution.ThrottlingPhaseTemplate;
import org.mule.runtime.module.http.api.HttpConstants;
import org.mule.runtime.module.http.internal.domain.InputStreamHttpEntity;
import org.mule.runtime.module.http.internal.domain.response.HttpResponse;
import org.mule.runtime.module.http.internal.listener.HttpResponseBuilder;
import org.mule.runtime.module.http.internal.listener.HttpThrottlingHeadersMapBuilder;
import org.mule.runtime.module.http.internal.listener.async.HttpResponseReadyCallback;
import org.mule.runtime.module.http.internal.listener.async.ResponseStatusCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMessageProcessorTemplate
implements AsyncResponseFlowProcessingPhaseTemplate,
ThrottlingPhaseTemplate {
    public static final int MESSAGE_DISCARD_STATUS_CODE = Integer.valueOf(System.getProperty("mule.transport.http.throttling.discardstatuscode", "429"));
    public static final String MESSAGE_DISCARD_MESSAGE_BODY = "API calls exceeded";
    public static final String MESSAGE_DISCARD_REASON_PHRASE = "Too Many Requests";
    public static final String X_RATE_LIMIT_LIMIT_HEADER = "X-RateLimit-Limit";
    public static final String X_RATE_LIMIT_REMAINING_HEADER = "X-RateLimit-Remaining";
    public static final String X_RATE_LIMIT_RESET_HEADER = "X-RateLimit-Reset";
    private static final int INTERNAL_SERVER_ERROR_STATUS_CODE = 500;
    private static final int OK_STATUS_CODE = 200;
    private static final Logger logger = LoggerFactory.getLogger(HttpMessageProcessorTemplate.class);
    private Event sourceMuleEvent;
    private Processor messageProcessor;
    private HttpResponseReadyCallback responseReadyCallback;
    private HttpResponseBuilder responseBuilder;
    private HttpResponseBuilder errorResponseBuilder;
    private HttpThrottlingHeadersMapBuilder httpThrottlingHeadersMapBuilder = new HttpThrottlingHeadersMapBuilder();

    public HttpMessageProcessorTemplate(Event sourceMuleEvent, Processor messageProcessor, HttpResponseReadyCallback responseReadyCallback, HttpResponseBuilder responseBuilder, HttpResponseBuilder errorResponseBuilder) {
        this.sourceMuleEvent = sourceMuleEvent;
        this.messageProcessor = messageProcessor;
        this.responseBuilder = responseBuilder;
        this.errorResponseBuilder = errorResponseBuilder;
        this.responseReadyCallback = responseReadyCallback;
    }

    public Event getEvent() throws MuleException {
        return this.sourceMuleEvent;
    }

    public Event routeEvent(Event muleEvent) throws MuleException {
        return this.messageProcessor.process(muleEvent);
    }

    public void sendResponseToClient(Event event, ResponseCompletionCallback responseCompletationCallback) throws MuleException {
        org.mule.runtime.module.http.internal.domain.response.HttpResponseBuilder responseBuilder = new org.mule.runtime.module.http.internal.domain.response.HttpResponseBuilder();
        HttpResponse httpResponse = this.buildResponse(event, responseBuilder, responseCompletationCallback);
        this.responseReadyCallback.responseReady(httpResponse, this.getResponseFailureCallback(responseCompletationCallback, event));
    }

    protected HttpResponse buildErrorResponse() {
        org.mule.runtime.module.http.internal.domain.response.HttpResponseBuilder errorResponseBuilder = new org.mule.runtime.module.http.internal.domain.response.HttpResponseBuilder();
        HttpResponse errorResponse = errorResponseBuilder.setStatusCode(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode()).setReasonPhrase(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase()).build();
        return errorResponse;
    }

    protected HttpResponse buildResponse(Event muleEvent, org.mule.runtime.module.http.internal.domain.response.HttpResponseBuilder responseBuilder, ResponseCompletionCallback responseCompletationCallback) {
        this.addThrottlingHeaders(responseBuilder);
        HttpResponse httpResponse = muleEvent == null ? responseBuilder.setStatusCode(200).build() : this.doBuildResponse(muleEvent, responseBuilder, responseCompletationCallback);
        return httpResponse;
    }

    protected HttpResponse doBuildResponse(Event muleEvent, org.mule.runtime.module.http.internal.domain.response.HttpResponseBuilder responseBuilder, ResponseCompletionCallback responseCompletationCallback) {
        try {
            return this.responseBuilder.build(responseBuilder, muleEvent);
        }
        catch (Exception e) {
            try {
                Event exceptionStrategyResult = responseCompletationCallback.responseSentWithFailure(new MessagingException(muleEvent, (Throwable)e), muleEvent);
                return this.responseBuilder.build(responseBuilder, exceptionStrategyResult);
            }
            catch (Exception innerException) {
                return this.buildErrorResponse();
            }
        }
    }

    private ResponseStatusCallback getResponseFailureCallback(final ResponseCompletionCallback responseCompletationCallback, Event muleEvent) {
        return new ResponseStatusCallback(){

            @Override
            public void responseSendFailure(Throwable throwable) {
                HttpMessageProcessorTemplate.this.responseReadyCallback.responseReady(HttpMessageProcessorTemplate.this.buildErrorResponse(), this);
            }

            @Override
            public void responseSendSuccessfully() {
                responseCompletationCallback.responseSentSuccessfully();
            }
        };
    }

    public void sendFailureResponseToClient(MessagingException messagingException, ResponseCompletionCallback responseCompletationCallback) throws MuleException {
        Throwable cause = messagingException.getCause();
        String exceptionStatusCode = ExceptionHelper.getTransportErrorMapping((String)HttpConstants.Protocols.HTTP.getScheme(), cause.getClass(), (MuleContext)this.responseBuilder.getMuleContext());
        Integer statusCodeFromException = exceptionStatusCode != null ? Integer.valueOf(exceptionStatusCode) : 500;
        org.mule.runtime.module.http.internal.domain.response.HttpResponseBuilder failureResponseBuilder = new org.mule.runtime.module.http.internal.domain.response.HttpResponseBuilder().setStatusCode(statusCodeFromException).setReasonPhrase(messagingException.getMessage());
        this.addThrottlingHeaders(failureResponseBuilder);
        Event event = messagingException.getEvent();
        Message errorMessage = this.resolveErrorMessage(event);
        event = Event.builder((Event)event).message(InternalMessage.builder((Message)errorMessage).payload((Object)messagingException.getMessage()).build()).build();
        HttpResponse response = this.errorResponseBuilder.build(failureResponseBuilder, event);
        this.responseReadyCallback.responseReady(response, this.getResponseFailureCallback(responseCompletationCallback, event));
    }

    private Message resolveErrorMessage(Event event) {
        Optional error = event.getError();
        if (error.isPresent() && ((Error)error.get()).getErrorMessage() != null && "SECURITY".equals(((Error)error.get()).getErrorType().getIdentifier())) {
            return ((Error)error.get()).getErrorMessage();
        }
        return event.getMessage();
    }

    public void discardMessageOnThrottlingExceeded() throws MuleException {
        org.mule.runtime.module.http.internal.domain.response.HttpResponseBuilder throttledResponseBuilder = new org.mule.runtime.module.http.internal.domain.response.HttpResponseBuilder().setStatusCode(MESSAGE_DISCARD_STATUS_CODE).setReasonPhrase(MESSAGE_DISCARD_REASON_PHRASE).setEntity(new InputStreamHttpEntity(new ByteArrayInputStream(MESSAGE_DISCARD_MESSAGE_BODY.getBytes())));
        this.addThrottlingHeaders(throttledResponseBuilder);
        this.responseReadyCallback.responseReady(throttledResponseBuilder.build(), this.getLogCompletionCallback());
    }

    private void addThrottlingHeaders(org.mule.runtime.module.http.internal.domain.response.HttpResponseBuilder throttledResponseBuilder) {
        Map<String, String> throttlingHeaders = this.getThrottlingHeaders();
        for (String throttlingHeaderName : throttlingHeaders.keySet()) {
            throttledResponseBuilder.addHeader(throttlingHeaderName, throttlingHeaders.get(throttlingHeaderName));
        }
    }

    private ResponseStatusCallback getLogCompletionCallback() {
        return new ResponseStatusCallback(){

            @Override
            public void responseSendFailure(Throwable throwable) {
                logger.info("Failure sending throttled response " + throwable.getMessage());
                if (logger.isDebugEnabled()) {
                    logger.debug(throwable.getMessage(), throwable);
                }
            }

            @Override
            public void responseSendSuccessfully() {
                if (logger.isDebugEnabled()) {
                    logger.debug("throttled response sent successfully");
                }
            }
        };
    }

    public void setThrottlingPolicyStatistics(long remainingRequestInCurrentPeriod, long maximumRequestAllowedPerPeriod, long timeUntilNextPeriodInMillis) {
        this.httpThrottlingHeadersMapBuilder.setThrottlingPolicyStatistics(remainingRequestInCurrentPeriod, maximumRequestAllowedPerPeriod, timeUntilNextPeriodInMillis);
    }

    private Map<String, String> getThrottlingHeaders() {
        return this.httpThrottlingHeadersMapBuilder.build();
    }
}

