/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.http.internal.listener;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.mule.compatibility.transport.socket.api.TcpServerSocketProperties;
import org.mule.compatibility.transport.socket.internal.DefaultTcpServerSocketProperties;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.AbstractAnnotatedObject;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ThreadingProfile;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.scheduler.Scheduler;
import org.mule.runtime.core.config.MutableThreadingProfile;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.util.NetworkUtils;
import org.mule.runtime.core.util.StringUtils;
import org.mule.runtime.module.http.api.HttpConstants;
import org.mule.runtime.module.http.api.HttpListenerConnectionManager;
import org.mule.runtime.module.http.api.listener.HttpListenerConfig;
import org.mule.runtime.module.http.internal.HttpParser;
import org.mule.runtime.module.http.internal.listener.ListenerPath;
import org.mule.runtime.module.http.internal.listener.RequestHandlerManager;
import org.mule.runtime.module.http.internal.listener.Server;
import org.mule.runtime.module.http.internal.listener.ServerAddress;
import org.mule.runtime.module.http.internal.listener.async.RequestHandler;
import org.mule.runtime.module.http.internal.listener.matcher.ListenerRequestMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpListenerConfig
extends AbstractAnnotatedObject
implements HttpListenerConfig,
Initialisable,
MuleContextAware {
    public static final int DEFAULT_MAX_THREADS = 128;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final int DEFAULT_CONNECTION_IDLE_TIMEOUT = 30000;
    private HttpConstants.Protocols protocol = HttpConstants.Protocols.HTTP;
    private String name;
    private String host;
    private Integer port;
    private String basePath;
    private Boolean parseRequest;
    private MuleContext muleContext;
    @Inject
    private HttpListenerConnectionManager connectionManager;
    private TlsContextFactory tlsContext;
    private TcpServerSocketProperties serverSocketProperties = new DefaultTcpServerSocketProperties();
    private ThreadingProfile workerThreadingProfile;
    private boolean started = false;
    private Server server;
    private Scheduler workManager;
    private boolean initialised;
    private boolean usePersistentConnections = true;
    private int connectionIdleTimeout = 30000;

    public DefaultHttpListenerConfig() {
    }

    DefaultHttpListenerConfig(HttpListenerConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void setWorkerThreadingProfile(ThreadingProfile workerThreadingProfile) {
        this.workerThreadingProfile = workerThreadingProfile;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProtocol(HttpConstants.Protocols protocol) {
        this.protocol = protocol;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setTlsContext(TlsContextFactory tlsContext) {
        this.tlsContext = tlsContext;
    }

    public void setServerSocketProperties(TcpServerSocketProperties serverSocketProperties) {
        this.serverSocketProperties = serverSocketProperties;
    }

    public void setParseRequest(Boolean parseRequest) {
        this.parseRequest = parseRequest;
    }

    public ListenerPath getFullListenerPath(String listenerPath) {
        Preconditions.checkArgument((boolean)listenerPath.startsWith("/"), (String)"listenerPath must start with /");
        return new ListenerPath(this.basePath, listenerPath);
    }

    public synchronized void initialise() throws InitialisationException {
        ServerAddress serverAddress;
        if (this.initialised) {
            return;
        }
        this.basePath = HttpParser.sanitizePathWithStartSlash(this.basePath);
        if (this.workerThreadingProfile == null) {
            this.workerThreadingProfile = new MutableThreadingProfile(ThreadingProfile.DEFAULT_THREADING_PROFILE);
            this.workerThreadingProfile.setMaxThreadsActive(128);
        }
        if (this.port == null) {
            this.port = this.protocol.getDefaultPort();
        }
        if (this.protocol.equals((Object)HttpConstants.Protocols.HTTP) && this.tlsContext != null) {
            throw new InitialisationException(CoreMessages.createStaticMessage((String)"TlsContext cannot be configured with protocol HTTP. If you defined a tls:context element in your listener-config then you must set protocol=\"HTTPS\""), (Initialisable)this);
        }
        if (this.protocol.equals((Object)HttpConstants.Protocols.HTTPS) && this.tlsContext == null) {
            throw new InitialisationException(CoreMessages.createStaticMessage((String)"Configured protocol is HTTPS but there's no TlsContext configured"), (Initialisable)this);
        }
        if (this.tlsContext != null && !this.tlsContext.isKeyStoreConfigured()) {
            throw new InitialisationException(CoreMessages.createStaticMessage((String)"KeyStore must be configured for server side SSL"), (Initialisable)this);
        }
        this.verifyConnectionsParameters();
        try {
            serverAddress = this.createServerAddress();
        }
        catch (UnknownHostException e) {
            throw new InitialisationException(CoreMessages.createStaticMessage((String)"Cannot resolve host %s", (Object[])new Object[]{this.host}), (Throwable)e, (Initialisable)this);
        }
        if (this.tlsContext == null) {
            this.server = this.connectionManager.createServer(serverAddress, () -> this.workManager, this.usePersistentConnections, this.connectionIdleTimeout);
        } else {
            LifecycleUtils.initialiseIfNeeded((Object)this.tlsContext);
            this.server = this.connectionManager.createSslServer(serverAddress, () -> this.workManager, this.tlsContext, this.usePersistentConnections, this.connectionIdleTimeout);
        }
        this.initialised = true;
    }

    private void verifyConnectionsParameters() throws InitialisationException {
        if (!this.usePersistentConnections) {
            this.connectionIdleTimeout = 0;
        }
    }

    private ServerAddress createServerAddress() throws UnknownHostException {
        return new ServerAddress(NetworkUtils.getLocalHostIp((String)this.host), this.port);
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public RequestHandlerManager addRequestHandler(ListenerRequestMatcher requestMatcher, RequestHandler requestHandler) throws IOException {
        return this.server.addRequestHandler(requestMatcher, requestHandler);
    }

    public Boolean resolveParseRequest(Boolean listenerParseRequest) {
        return listenerParseRequest != null ? listenerParseRequest : (this.parseRequest != null ? this.parseRequest : true);
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public TlsContextFactory getTlsContext() {
        return this.tlsContext;
    }

    @Override
    public synchronized void start() throws MuleException {
        if (this.started) {
            return;
        }
        try {
            this.workManager = this.muleContext.getSchedulerService().cpuLightScheduler();
            this.server.start();
        }
        catch (IOException e) {
            throw new DefaultMuleException((Throwable)e);
        }
        this.started = true;
        this.logger.info("Listening for requests on " + this.listenerUrl());
    }

    @Override
    public boolean hasTlsConfig() {
        return this.tlsContext != null;
    }

    @Override
    public synchronized void stop() throws MuleException {
        if (this.started) {
            try {
                this.workManager.stop((long)this.muleContext.getConfiguration().getShutdownTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                this.logger.warn("Failure shutting down work manager " + e.getMessage());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(e.getMessage(), (Throwable)e);
                }
            }
            finally {
                this.workManager = null;
            }
            this.server.stop();
            this.started = false;
            this.logger.info("Stopped listener on " + this.listenerUrl());
        }
    }

    private String listenerUrl() {
        return String.format("%s://%s:%d%s", this.protocol.getScheme(), this.getHost(), this.getPort(), StringUtils.defaultString((String)this.basePath));
    }

    public String getName() {
        return this.name;
    }

    Executor getWorkManager() {
        return this.workManager;
    }

    public void setUsePersistentConnections(boolean usePersistentConnections) {
        this.usePersistentConnections = usePersistentConnections;
    }

    public void setConnectionIdleTimeout(int connectionIdleTimeout) {
        this.connectionIdleTimeout = connectionIdleTimeout;
    }

    public boolean isStarted() {
        return this.started;
    }
}

