/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.http.internal.filter;

import java.io.Serializable;
import org.apache.commons.codec.binary.Base64;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.security.Authentication;
import org.mule.runtime.core.api.security.Credentials;
import org.mule.runtime.core.api.security.CryptoFailureException;
import org.mule.runtime.core.api.security.EncryptionStrategyNotFoundException;
import org.mule.runtime.core.api.security.SecurityContext;
import org.mule.runtime.core.api.security.SecurityException;
import org.mule.runtime.core.api.security.SecurityFilter;
import org.mule.runtime.core.api.security.SecurityProviderNotFoundException;
import org.mule.runtime.core.api.security.UnauthorisedException;
import org.mule.runtime.core.api.security.UnknownAuthenticationTypeException;
import org.mule.runtime.core.api.security.UnsupportedAuthenticationSchemeException;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.security.AbstractAuthenticationFilter;
import org.mule.runtime.core.security.DefaultMuleAuthentication;
import org.mule.runtime.core.security.MuleCredentials;
import org.mule.runtime.module.http.api.HttpConstants;
import org.mule.runtime.module.http.internal.filter.BasicUnauthorisedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpBasicAuthenticationFilter
extends AbstractAuthenticationFilter {
    protected static final Logger logger = LoggerFactory.getLogger(HttpBasicAuthenticationFilter.class);
    private String realm;
    private boolean realmRequired = true;

    protected void doInitialise() throws InitialisationException {
        if (this.realm == null) {
            if (this.isRealmRequired()) {
                throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"The \"realm\" must be set on this security filter"), (Initialisable)this);
            }
            logger.warn("There is no security realm set, using default: null");
        }
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public boolean isRealmRequired() {
        return this.realmRequired;
    }

    public void setRealmRequired(boolean realmRequired) {
        this.realmRequired = realmRequired;
    }

    protected Authentication createAuthentication(String username, String password, Event event) {
        return new DefaultMuleAuthentication((Credentials)new MuleCredentials(username, password.toCharArray()), event);
    }

    protected Event setUnauthenticated(Event event) {
        String realmHeader = "Basic realm=";
        if (this.realm != null) {
            realmHeader = realmHeader + "\"" + this.realm + "\"";
        }
        String finalRealmHeader = realmHeader;
        return Event.builder((Event)event).message(InternalMessage.builder((InternalMessage)event.getMessage()).addOutboundProperty("WWW-Authenticate", (Serializable)((Object)finalRealmHeader)).addOutboundProperty("http.status", (Serializable)Integer.valueOf(HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode())).build()).build();
    }

    public Event authenticate(Event event) throws SecurityException, UnknownAuthenticationTypeException, CryptoFailureException, SecurityProviderNotFoundException, EncryptionStrategyNotFoundException, InitialisationException {
        String header = (String)((Object)event.getMessage().getInboundProperty("Authorization"));
        if (logger.isDebugEnabled()) {
            logger.debug("Authorization header: " + header);
        }
        if (header != null && header.startsWith("Basic ")) {
            Authentication authResult;
            String base64Token = header.substring(6);
            String token = new String(Base64.decodeBase64((byte[])base64Token.getBytes()));
            String username = "";
            String password = "";
            int delim = token.indexOf(":");
            if (delim != -1) {
                username = token.substring(0, delim);
                password = token.substring(delim + 1);
            }
            Authentication authentication = this.createAuthentication(username, password, event);
            try {
                authResult = this.getSecurityManager().authenticate(authentication);
            }
            catch (UnauthorisedException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Authentication request for user: " + username + " failed: " + e.toString());
                }
                event = this.setUnauthenticated(event);
                throw new BasicUnauthorisedException(CoreMessages.authFailedForUser((Object)username), e, (Message)event.getMessage());
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Authentication success: " + authResult.toString());
            }
            SecurityContext context = this.getSecurityManager().createSecurityContext(authResult);
            context.setAuthentication(authResult);
            event.getSession().setSecurityContext(context);
            return event;
        }
        if (header == null) {
            event = this.setUnauthenticated(event);
            throw new BasicUnauthorisedException(event, event.getSession().getSecurityContext(), (SecurityFilter)this);
        }
        event = this.setUnauthenticated(event);
        throw new UnsupportedAuthenticationSchemeException(I18nMessageFactory.createStaticMessage((String)("Http Basic filter doesn't know how to handle header " + header)), (Message)event.getMessage());
    }
}

