/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.http.api;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.mule.compatibility.transport.socket.api.TcpServerSocketProperties;
import org.mule.compatibility.transport.socket.internal.DefaultTcpServerSocketProperties;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.util.concurrent.ThreadNameHelper;
import org.mule.runtime.module.http.internal.listener.HttpListenerRegistry;
import org.mule.runtime.module.http.internal.listener.HttpServerManager;
import org.mule.runtime.module.http.internal.listener.Server;
import org.mule.runtime.module.http.internal.listener.ServerAddress;
import org.mule.runtime.module.http.internal.listener.grizzly.GrizzlyServerManager;

public class HttpListenerConnectionManager
implements Initialisable,
Disposable,
MuleContextAware {
    public static final String HTTP_LISTENER_CONNECTION_MANAGER = "_httpListenerConnectionManager";
    public static final String SERVER_ALREADY_EXISTS_FORMAT = "A server in port(%s) already exists for ip(%s) or one overlapping it (0.0.0.0).";
    private static final String LISTENER_THREAD_NAME_PREFIX = "http.listener";
    private HttpListenerRegistry httpListenerRegistry = new HttpListenerRegistry();
    private HttpServerManager httpServerManager;
    private MuleContext muleContext;

    public void initialise() throws InitialisationException {
        Collection tcpServerSocketPropertiesBeans = this.muleContext.getRegistry().lookupObjects(TcpServerSocketProperties.class);
        DefaultTcpServerSocketProperties tcpServerSocketProperties = new DefaultTcpServerSocketProperties();
        if (tcpServerSocketPropertiesBeans.size() == 1) {
            tcpServerSocketProperties = (TcpServerSocketProperties)Iterables.getOnlyElement((Iterable)tcpServerSocketPropertiesBeans);
        } else if (tcpServerSocketPropertiesBeans.size() > 1) {
            throw new InitialisationException(CoreMessages.createStaticMessage((String)"Only one global TCP server socket properties bean should be defined in the config"), (Initialisable)this);
        }
        String threadNamePrefix = ThreadNameHelper.getPrefix((MuleContext)this.muleContext) + LISTENER_THREAD_NAME_PREFIX;
        try {
            this.httpServerManager = new GrizzlyServerManager(threadNamePrefix, this.httpListenerRegistry, (TcpServerSocketProperties)tcpServerSocketProperties);
        }
        catch (IOException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public synchronized void dispose() {
        this.httpServerManager.dispose();
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public Server createServer(ServerAddress serverAddress, Supplier<Executor> workManagerSource, boolean usePersistentConnections, int connectionIdleTimeout) {
        if (!this.containsServerFor(serverAddress)) {
            try {
                return this.httpServerManager.createServerFor(serverAddress, workManagerSource, usePersistentConnections, connectionIdleTimeout);
            }
            catch (IOException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)String.format(SERVER_ALREADY_EXISTS_FORMAT, serverAddress.getPort(), serverAddress.getIp())));
    }

    public boolean containsServerFor(ServerAddress serverAddress) {
        return this.httpServerManager.containsServerFor(serverAddress);
    }

    public Server createSslServer(ServerAddress serverAddress, Supplier<Executor> workManagerSource, TlsContextFactory tlsContext, boolean usePersistentConnections, int connectionIdleTimeout) {
        if (!this.containsServerFor(serverAddress)) {
            try {
                return this.httpServerManager.createSslServerFor(tlsContext, workManagerSource, serverAddress, usePersistentConnections, connectionIdleTimeout);
            }
            catch (IOException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)String.format(SERVER_ALREADY_EXISTS_FORMAT, serverAddress.getPort(), serverAddress.getIp())));
    }
}

