/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request.grizzly;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.AsyncHttpProviderConfig;
import com.ning.http.client.BodyDeferringAsyncHandler;
import com.ning.http.client.BodyGenerator;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.filter.RequestFilter;
import com.ning.http.client.generators.InputStreamBodyGenerator;
import com.ning.http.client.multipart.ByteArrayPart;
import com.ning.http.client.multipart.Part;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProviderConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import org.mule.extension.http.api.request.authentication.HttpAuthentication;
import org.mule.extension.http.api.request.client.HttpClient;
import org.mule.extension.http.api.request.client.UriParameters;
import org.mule.extension.http.api.request.proxy.NtlmProxyConfig;
import org.mule.extension.http.api.request.proxy.ProxyConfig;
import org.mule.extension.http.internal.request.DefaultHttpRequest;
import org.mule.extension.http.internal.request.client.HttpClientConfiguration;
import org.mule.extension.http.internal.request.grizzly.SocketConfigTransportCustomizer;
import org.mule.extension.socket.api.socket.tcp.TcpClientSocketProperties;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.tls.TlsContextTrustStoreConfiguration;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.core.util.StringUtils;
import org.mule.runtime.module.http.internal.domain.ByteArrayHttpEntity;
import org.mule.runtime.module.http.internal.domain.InputStreamHttpEntity;
import org.mule.runtime.module.http.internal.domain.MultipartHttpEntity;
import org.mule.runtime.module.http.internal.domain.request.HttpRequest;
import org.mule.runtime.module.http.internal.domain.request.HttpRequestAuthentication;
import org.mule.runtime.module.http.internal.domain.response.HttpResponse;
import org.mule.runtime.module.http.internal.domain.response.HttpResponseBuilder;
import org.mule.runtime.module.http.internal.multipart.HttpPart;
import org.mule.runtime.module.http.internal.request.HttpAuthenticationType;
import org.mule.runtime.module.http.internal.request.grizzly.CompositeTransportCustomizer;
import org.mule.runtime.module.http.internal.request.grizzly.CustomTimeoutThrottleRequestFilter;
import org.mule.runtime.module.http.internal.request.grizzly.IOStrategyTransportCustomizer;
import org.mule.runtime.module.http.internal.request.grizzly.LoggerTransportCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrizzlyHttpClient
implements HttpClient {
    private static final int MAX_CONNECTION_LIFETIME = 1800000;
    private static final Logger logger = LoggerFactory.getLogger(GrizzlyHttpClient.class);
    private UriParameters uriParameters;
    private HttpAuthentication authentication;
    private final TlsContextFactory tlsContextFactory;
    private final ProxyConfig proxyConfig;
    private final TcpClientSocketProperties clientSocketProperties;
    private int maxConnections;
    private boolean usePersistentConnections;
    private int connectionIdleTimeout;
    private String threadNamePrefix;
    private String ownerName;
    private AsyncHttpClient asyncHttpClient;
    private SSLContext sslContext;

    public GrizzlyHttpClient(HttpClientConfiguration config) {
        this.uriParameters = config.getUriParameters();
        this.authentication = config.getAuthentication();
        this.tlsContextFactory = config.getTlsContextFactory();
        this.proxyConfig = config.getProxyConfig();
        this.clientSocketProperties = config.getClientSocketProperties();
        this.maxConnections = config.getMaxConnections();
        this.usePersistentConnections = config.isUsePersistentConnections();
        this.connectionIdleTimeout = config.getConnectionIdleTimeout();
        this.threadNamePrefix = config.getThreadNamePrefix();
        this.ownerName = config.getOwnerName();
    }

    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded((Object)this.authentication);
        AsyncHttpClientConfig.Builder builder = new AsyncHttpClientConfig.Builder();
        builder.setAllowPoolingConnections(true);
        this.configureTransport(builder);
        this.configureTlsContext(builder);
        this.configureProxy(builder);
        this.configureConnections(builder);
        AsyncHttpClientConfig config = builder.build();
        this.asyncHttpClient = new AsyncHttpClient((AsyncHttpProvider)new GrizzlyAsyncHttpProvider(config), config);
    }

    private void configureTlsContext(AsyncHttpClientConfig.Builder builder) {
        if (this.tlsContextFactory != null) {
            TlsContextTrustStoreConfiguration trustStoreConfiguration;
            try {
                this.sslContext = this.tlsContextFactory.createSslContext();
            }
            catch (Exception e) {
                throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)"Cannot initialize SSL context"), (Throwable)e);
            }
            builder.setSSLContext(this.sslContext);
            if (this.tlsContextFactory.getEnabledCipherSuites() != null) {
                builder.setEnabledCipherSuites(this.tlsContextFactory.getEnabledCipherSuites());
            }
            if (this.tlsContextFactory.getEnabledProtocols() != null) {
                builder.setEnabledProtocols(this.tlsContextFactory.getEnabledProtocols());
            }
            if ((trustStoreConfiguration = this.tlsContextFactory.getTrustStoreConfiguration()) != null && trustStoreConfiguration.isInsecure()) {
                logger.warn(String.format("TLS configuration for requester %s has been set to use an insecure trust store. This means no certificate validations will be performed, rendering connections vulnerable to attacks. Use at own risk.", this.ownerName));
                builder.setAcceptAnyCertificate(true);
            }
        }
    }

    private void configureProxy(AsyncHttpClientConfig.Builder builder) {
        if (this.proxyConfig != null) {
            this.doConfigureProxy(builder, this.proxyConfig);
        }
    }

    protected void doConfigureProxy(AsyncHttpClientConfig.Builder builder, ProxyConfig proxyConfig) {
        builder.setProxyServer(this.buildProxy(proxyConfig));
    }

    protected final ProxyServer buildProxy(ProxyConfig proxyConfig) {
        ProxyServer proxyServer;
        if (!StringUtils.isEmpty((String)proxyConfig.getUsername())) {
            proxyServer = new ProxyServer(proxyConfig.getHost(), proxyConfig.getPort(), proxyConfig.getUsername(), proxyConfig.getPassword());
            if (proxyConfig instanceof NtlmProxyConfig) {
                proxyServer.setNtlmDomain(((NtlmProxyConfig)proxyConfig).getNtlmDomain());
                try {
                    proxyServer.setNtlmHost(this.getHostName());
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                proxyServer.setScheme(Realm.AuthScheme.NTLM);
            }
        } else {
            proxyServer = new ProxyServer(proxyConfig.getHost(), proxyConfig.getPort());
        }
        return proxyServer;
    }

    private void configureTransport(AsyncHttpClientConfig.Builder builder) {
        GrizzlyAsyncHttpProviderConfig providerConfig = new GrizzlyAsyncHttpProviderConfig();
        CompositeTransportCustomizer compositeTransportCustomizer = new CompositeTransportCustomizer();
        compositeTransportCustomizer.addTransportCustomizer(new IOStrategyTransportCustomizer(this.threadNamePrefix));
        compositeTransportCustomizer.addTransportCustomizer(new LoggerTransportCustomizer());
        if (this.clientSocketProperties != null) {
            compositeTransportCustomizer.addTransportCustomizer(new SocketConfigTransportCustomizer(this.clientSocketProperties));
        }
        providerConfig.addProperty(GrizzlyAsyncHttpProviderConfig.Property.TRANSPORT_CUSTOMIZER, (Object)compositeTransportCustomizer);
        providerConfig.addProperty(GrizzlyAsyncHttpProviderConfig.Property.DECOMPRESS_RESPONSE, (Object)Boolean.FALSE);
        builder.setAsyncHttpClientProviderConfig((AsyncHttpProviderConfig)providerConfig);
    }

    private void configureConnections(AsyncHttpClientConfig.Builder builder) {
        if (this.maxConnections > 0) {
            builder.addRequestFilter((RequestFilter)new CustomTimeoutThrottleRequestFilter(this.maxConnections));
        }
        builder.setMaxConnections(this.maxConnections);
        builder.setMaxConnectionsPerHost(this.maxConnections);
        builder.setAllowPoolingConnections(this.usePersistentConnections);
        builder.setAllowPoolingSslConnections(this.usePersistentConnections);
        builder.setConnectionTTL(1800000);
        builder.setPooledConnectionIdleTimeout(this.connectionIdleTimeout);
        builder.setIOThreadMultiplier(1);
    }

    @Override
    public UriParameters getDefaultUriParameters() {
        return this.uriParameters;
    }

    @Override
    public HttpAuthentication getDefaultAuthentication() {
        return this.authentication;
    }

    @Override
    public HttpResponse send(HttpRequest request, int responseTimeout, boolean followRedirects, HttpRequestAuthentication authentication) throws IOException, TimeoutException {
        Request grizzlyRequest = this.createGrizzlyRequest(request, responseTimeout, followRedirects, authentication);
        PipedOutputStream outPipe = new PipedOutputStream();
        PipedInputStream inPipe = new PipedInputStream(outPipe);
        BodyDeferringAsyncHandler asyncHandler = new BodyDeferringAsyncHandler((OutputStream)outPipe);
        this.asyncHttpClient.executeRequest(grizzlyRequest, (AsyncHandler)asyncHandler);
        try {
            Response response = asyncHandler.getResponse();
            return this.createMuleResponse(response, inPipe);
        }
        catch (IOException e) {
            if (e.getCause() instanceof TimeoutException) {
                throw (TimeoutException)e.getCause();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private HttpResponse createMuleResponse(Response response, InputStream inputStream) throws IOException {
        HttpResponseBuilder responseBuilder = new HttpResponseBuilder();
        responseBuilder.setStatusCode(response.getStatusCode());
        responseBuilder.setReasonPhrase(response.getStatusText());
        responseBuilder.setEntity(new InputStreamHttpEntity(inputStream));
        if (response.hasResponseHeaders()) {
            for (String header : response.getHeaders().keySet()) {
                for (String headerValue : response.getHeaders(header)) {
                    responseBuilder.addHeader(header, headerValue);
                }
            }
        }
        return responseBuilder.build();
    }

    private Request createGrizzlyRequest(HttpRequest request, int responseTimeout, boolean followRedirects, HttpRequestAuthentication authentication) throws IOException {
        RequestBuilder reqBuilder = this.createRequestBuilder(request, builder -> {
            builder.setMethod(request.getMethod());
            builder.setFollowRedirects(followRedirects);
            this.populateHeaders(request, builder);
            DefaultHttpRequest defaultHttpRequest = (DefaultHttpRequest)request;
            for (String queryParamName : defaultHttpRequest.getQueryParams().keySet()) {
                builder.addQueryParam(queryParamName, defaultHttpRequest.getQueryParams().get(queryParamName));
            }
            if (authentication != null) {
                Realm.RealmBuilder realmBuilder = new Realm.RealmBuilder().setPrincipal(authentication.getUsername()).setPassword(authentication.getPassword()).setUsePreemptiveAuth(authentication.isPreemptive());
                if (authentication.getType() == HttpAuthenticationType.BASIC) {
                    realmBuilder.setScheme(Realm.AuthScheme.BASIC);
                } else if (authentication.getType() == HttpAuthenticationType.DIGEST) {
                    realmBuilder.setScheme(Realm.AuthScheme.DIGEST);
                } else if (authentication.getType() == HttpAuthenticationType.NTLM) {
                    String workstation;
                    String domain = authentication.getDomain();
                    if (domain != null) {
                        realmBuilder.setNtlmDomain(domain);
                    }
                    String ntlmHost = (workstation = authentication.getWorkstation()) != null ? workstation : this.getHostName();
                    realmBuilder.setNtlmHost(ntlmHost).setScheme(Realm.AuthScheme.NTLM);
                }
                builder.setRealm(realmBuilder.build());
            }
            if (request.getEntity() != null) {
                if (request.getEntity() instanceof InputStreamHttpEntity) {
                    builder.setBody((BodyGenerator)new InputStreamBodyGenerator(((InputStreamHttpEntity)request.getEntity()).getInputStream()));
                } else if (request.getEntity() instanceof ByteArrayHttpEntity) {
                    builder.setBody(((ByteArrayHttpEntity)request.getEntity()).getContent());
                } else if (request.getEntity() instanceof MultipartHttpEntity) {
                    MultipartHttpEntity multipartHttpEntity = (MultipartHttpEntity)request.getEntity();
                    for (HttpPart part : multipartHttpEntity.getParts()) {
                        if (part.getFileName() != null) {
                            builder.addBodyPart((Part)new ByteArrayPart(part.getName(), IOUtils.toByteArray((InputStream)part.getInputStream()), part.getContentType(), null, part.getFileName()));
                            continue;
                        }
                        byte[] content = IOUtils.toByteArray((InputStream)part.getInputStream());
                        builder.addBodyPart((Part)new ByteArrayPart(part.getName(), content, part.getContentType(), null));
                    }
                }
            }
            builder.setRequestTimeout(responseTimeout);
        });
        reqBuilder.setUrl(request.getUri());
        return reqBuilder.build();
    }

    protected RequestBuilder createRequestBuilder(HttpRequest request, RequestConfigurer requestConfigurer) throws IOException {
        RequestBuilder requestBuilder = new RequestBuilder();
        requestConfigurer.configure(requestBuilder);
        return requestBuilder;
    }

    protected void populateHeaders(HttpRequest request, RequestBuilder builder) {
        for (String headerName : request.getHeaderNames()) {
            for (String headerValue : request.getHeaderValues(headerName)) {
                builder.addHeader(headerName, headerValue);
            }
        }
        if (!this.usePersistentConnections) {
            String connectionHeaderValue = request.getHeaderValueIgnoreCase("Connection");
            if (connectionHeaderValue != null && !"close".equals(connectionHeaderValue) && logger.isDebugEnabled()) {
                logger.debug("Persistent connections are disabled in the HTTP requester configuration, but the request already contains a Connection header with value {}. This header will be ignored, and a Connection: close header will be sent instead.", (Object)connectionHeaderValue);
            }
            builder.setHeader("Connection", "close");
        }
    }

    private String getHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }

    protected ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)this.authentication);
        this.asyncHttpClient.close();
    }

    @FunctionalInterface
    protected static interface RequestConfigurer {
        public void configure(RequestBuilder var1) throws IOException;
    }
}

