/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mule.extension.http.api.HttpSendBodyMode;
import org.mule.extension.http.api.HttpStreamingType;
import org.mule.extension.http.api.request.authentication.HttpAuthentication;
import org.mule.extension.http.api.request.builder.HttpRequesterRequestBuilder;
import org.mule.extension.http.internal.request.HttpRequestBuilder;
import org.mule.extension.http.internal.request.HttpRequesterConfig;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.message.MultiPartPayload;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.TransformationService;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.model.ParameterMap;
import org.mule.runtime.core.util.SystemUtils;
import org.mule.runtime.module.http.api.HttpHeaders;
import org.mule.runtime.module.http.internal.HttpParser;
import org.mule.runtime.module.http.internal.domain.ByteArrayHttpEntity;
import org.mule.runtime.module.http.internal.domain.EmptyHttpEntity;
import org.mule.runtime.module.http.internal.domain.HttpEntity;
import org.mule.runtime.module.http.internal.domain.InputStreamHttpEntity;
import org.mule.runtime.module.http.internal.domain.MultipartHttpEntity;
import org.mule.runtime.module.http.internal.domain.request.HttpRequest;
import org.mule.runtime.module.http.internal.multipart.HttpPartDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleEventToHttpRequest {
    private static final Logger logger = LoggerFactory.getLogger(MuleEventToHttpRequest.class);
    public static final List<String> DEFAULT_EMPTY_BODY_METHODS = Lists.newArrayList((Object[])new String[]{"GET", "HEAD", "OPTIONS"});
    private static final String APPLICATION_JAVA = "application/java";
    private final String uri;
    private final String method;
    private final HttpRequesterConfig config;
    private final HttpStreamingType streamingMode;
    private final HttpSendBodyMode sendBodyMode;
    private final TransformationService transformationService;

    public MuleEventToHttpRequest(HttpRequesterConfig config, String uri, String method, HttpStreamingType streamingMode, HttpSendBodyMode sendBodyMode, TransformationService transformationService) {
        this.config = config;
        this.uri = uri;
        this.method = method;
        this.streamingMode = streamingMode;
        this.sendBodyMode = sendBodyMode;
        this.transformationService = transformationService;
    }

    public HttpRequest create(Event event, HttpRequesterRequestBuilder requestBuilder, HttpAuthentication authentication, MuleContext muleContext) throws MuleException {
        HttpRequestBuilder builder = new HttpRequestBuilder();
        builder.setUri(this.uri);
        builder.setMethod(this.method);
        builder.setHeaders(this.toParameterMap(requestBuilder.getHeaders()));
        builder.setQueryParams(this.toParameterMap(requestBuilder.getQueryParams()));
        MediaType mediaType = requestBuilder.getMediaType();
        if (!builder.getHeaders().containsKey("Content-Type") && !MediaType.ANY.matches(mediaType)) {
            builder.addHeader("Content-Type", mediaType.toRfcString());
        }
        if (this.config.isEnableCookies()) {
            try {
                Map<String, List<String>> headers = this.config.getCookieManager().get(URI.create(this.uri), Collections.emptyMap());
                List<String> cookies = headers.get("Cookie");
                if (cookies != null) {
                    for (String cookie : cookies) {
                        builder.addHeader("Cookie", cookie);
                    }
                }
            }
            catch (IOException e) {
                logger.warn("Error reading cookies for URI " + this.uri, (Throwable)e);
            }
        }
        builder.setEntity(this.createRequestEntity(builder, event, this.method, muleContext, requestBuilder.getBody(), mediaType));
        if (authentication != null) {
            authentication.authenticate(event, builder);
        }
        return builder.build();
    }

    private ParameterMap toParameterMap(Map<String, String> map) {
        ParameterMap parameterMap = new ParameterMap();
        map.forEach((arg_0, arg_1) -> ((ParameterMap)parameterMap).put(arg_0, arg_1));
        return parameterMap;
    }

    private HttpEntity createRequestEntity(HttpRequestBuilder requestBuilder, Event muleEvent, String resolvedMethod, MuleContext muleContext, Object body, MediaType mediaType) throws MessagingException {
        HttpEntity entity = this.isEmptyBody(body, resolvedMethod) ? new EmptyHttpEntity() : this.createRequestEntityFromPayload(requestBuilder, muleEvent, body, muleContext, mediaType);
        return entity;
    }

    private boolean isEmptyBody(Object body, String method) {
        boolean emptyBody;
        if (body == null) {
            emptyBody = true;
        } else {
            emptyBody = DEFAULT_EMPTY_BODY_METHODS.contains(method);
            if (this.sendBodyMode != HttpSendBodyMode.AUTO) {
                emptyBody = this.sendBodyMode == HttpSendBodyMode.NEVER;
            }
        }
        return emptyBody;
    }

    private HttpEntity createRequestEntityFromPayload(HttpRequestBuilder requestBuilder, Event muleEvent, Object payload, MuleContext muleContext, MediaType mediaType) throws MessagingException {
        if (payload instanceof MultiPartPayload) {
            try {
                Transformer objectToByteArray = muleContext.getRegistry().lookupTransformer(DataType.OBJECT, DataType.BYTE_ARRAY);
                return new MultipartHttpEntity(HttpPartDataSource.createFrom((MultiPartPayload)payload, objectToByteArray));
            }
            catch (Exception e) {
                throw new MessagingException(muleEvent, (Throwable)e);
            }
        }
        if (this.doStreaming(requestBuilder, payload)) {
            if (payload instanceof InputStream) {
                return new InputStreamHttpEntity((InputStream)payload);
            }
            try {
                return new InputStreamHttpEntity(new ByteArrayInputStream(this.getMessageAsBytes(payload)));
            }
            catch (Exception e) {
                throw new MessagingException(muleEvent, (Throwable)e);
            }
        }
        String contentType = requestBuilder.getHeaders().get("Content-Type");
        if ((contentType == null || contentType.startsWith(HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED.toRfcString()) || contentType.startsWith(APPLICATION_JAVA)) && payload instanceof Map) {
            String body = HttpParser.encodeString(mediaType.getCharset().orElse(SystemUtils.getDefaultEncoding((MuleContext)muleContext)), (Map)payload);
            requestBuilder.addHeader("Content-Type", HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED.toRfcString());
            return new ByteArrayHttpEntity(body.getBytes());
        }
        try {
            return new ByteArrayHttpEntity(this.getMessageAsBytes(payload));
        }
        catch (Exception e) {
            throw new MessagingException(muleEvent, (Throwable)e);
        }
    }

    private byte[] getMessageAsBytes(Object payload) {
        try {
            return (byte[])this.transformationService.transform(InternalMessage.of((Object)payload), DataType.BYTE_ARRAY).getPayload().getValue();
        }
        catch (TransformerException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private boolean doStreaming(HttpRequestBuilder requestBuilder, Object payload) throws MessagingException {
        String transferEncodingHeader = requestBuilder.getHeaders().get("Transfer-Encoding");
        String contentLengthHeader = requestBuilder.getHeaders().get("Content-Length");
        if (this.streamingMode == HttpStreamingType.AUTO) {
            if (contentLengthHeader != null) {
                if (transferEncodingHeader != null) {
                    requestBuilder.removeHeader("Transfer-Encoding");
                    if (logger.isDebugEnabled()) {
                        logger.debug("Cannot send both Transfer-Encoding and Content-Length headers. Transfer-Encoding will not be sent.");
                    }
                }
                return false;
            }
            if (transferEncodingHeader == null || !transferEncodingHeader.equalsIgnoreCase("chunked")) {
                return payload instanceof InputStream;
            }
            return true;
        }
        if (this.streamingMode == HttpStreamingType.ALWAYS) {
            if (contentLengthHeader != null) {
                requestBuilder.removeHeader("Content-Length");
                if (logger.isDebugEnabled()) {
                    logger.debug("Content-Length header will not be sent, as the configured requestStreamingMode is ALWAYS");
                }
            }
            if (transferEncodingHeader != null && !transferEncodingHeader.equalsIgnoreCase("chunked")) {
                requestBuilder.removeHeader("Transfer-Encoding");
                if (logger.isDebugEnabled()) {
                    logger.debug("Transfer-Encoding header will be sent with value 'chunked' instead of {}, as the configured requestStreamingMode is NEVER", (Object)transferEncodingHeader);
                }
            }
            return true;
        }
        if (transferEncodingHeader != null) {
            requestBuilder.removeHeader("Transfer-Encoding");
            if (logger.isDebugEnabled()) {
                logger.debug("Transfer-Encoding header will not be sent, as the configured requestStreamingMode is NEVER");
            }
        }
        return false;
    }
}

