/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request;

import java.net.CookieManager;
import java.util.function.Function;
import javax.inject.Inject;
import org.mule.extension.http.api.HttpSendBodyMode;
import org.mule.extension.http.api.HttpStreamingType;
import org.mule.extension.http.api.request.RamlApiConfiguration;
import org.mule.extension.http.internal.request.HttpRequestOperations;
import org.mule.extension.http.internal.request.HttpRequesterProvider;
import org.mule.extension.http.internal.request.OtherRequestSettings;
import org.mule.extension.http.internal.request.RequestSettings;
import org.mule.extension.http.internal.request.RequestUrlConfiguration;
import org.mule.extension.http.internal.request.ResponseSettings;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

@Configuration(name="request-config")
@ConnectionProviders(value={HttpRequesterProvider.class})
@Operations(value={HttpRequestOperations.class})
public class HttpRequesterConfig
implements Initialisable {
    @ParameterGroup(value="URL Configuration")
    @NullSafe
    private RequestUrlConfiguration urlConfiguration;
    @ParameterGroup(value="Request Settings")
    @NullSafe
    private RequestSettings requestSettings;
    @ParameterGroup(value="Response Settings")
    @NullSafe
    private ResponseSettings responseSettings;
    @ParameterGroup(value="Other Settings")
    @NullSafe
    private OtherRequestSettings otherSettings;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="API Configuration")
    private RamlApiConfiguration apiConfiguration;
    @Inject
    private MuleContext muleContext;
    private CookieManager cookieManager;

    public void initialise() throws InitialisationException {
        if (this.otherSettings.isEnableCookies()) {
            this.cookieManager = new CookieManager();
        }
    }

    public Function<Event, String> getBasePath() {
        return this.urlConfiguration.getBasePath();
    }

    public Function<Event, Boolean> getFollowRedirects() {
        return this.requestSettings.getFollowRedirects();
    }

    public Function<Event, Boolean> getParseResponse() {
        return this.responseSettings.getParseResponse();
    }

    public Function<Event, HttpStreamingType> getRequestStreamingMode() {
        return this.requestSettings.getRequestStreamingMode();
    }

    public Function<Event, HttpSendBodyMode> getSendBodyMode() {
        return this.requestSettings.getSendBodyMode();
    }

    public Function<Event, Integer> getResponseTimeout() {
        return this.responseSettings.getResponseTimeout();
    }

    public boolean isEnableCookies() {
        return this.otherSettings.isEnableCookies();
    }

    public RamlApiConfiguration getApiConfiguration() {
        return this.apiConfiguration;
    }

    public CookieManager getCookieManager() {
        return this.cookieManager;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }
}

