/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.listener.server;

import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.mule.runtime.api.tls.TlsContextFactory;

public class HttpServerConfiguration {
    private final String host;
    private final int port;
    private final TlsContextFactory tlsContextFactory;
    private final boolean usePersistentConnections;
    private final int connectionIdleTimeout;
    private final Supplier<Executor> workManagerSupplier;

    public HttpServerConfiguration(String host, int port, TlsContextFactory tlsContextFactory, boolean usePersistentConnections, int connectionIdleTimeout, Supplier<Executor> workManagerSupplier) {
        this.host = host;
        this.port = port;
        this.tlsContextFactory = tlsContextFactory;
        this.usePersistentConnections = usePersistentConnections;
        this.connectionIdleTimeout = connectionIdleTimeout;
        this.workManagerSupplier = workManagerSupplier;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public TlsContextFactory getTlsContextFactory() {
        return this.tlsContextFactory;
    }

    public boolean isUsePersistentConnections() {
        return this.usePersistentConnections;
    }

    public int getConnectionIdleTimeout() {
        return this.connectionIdleTimeout;
    }

    public Supplier<Executor> getWorkManagerSupplier() {
        return this.workManagerSupplier;
    }

    public static class Builder {
        private String host;
        private int port;
        private TlsContextFactory tlsContextFactory;
        private boolean usePersistentConnections;
        private int connectionIdleTimeout;
        private Supplier<Executor> workManagerSupplier;

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setTlsContextFactory(TlsContextFactory tlsContextFactory) {
            this.tlsContextFactory = tlsContextFactory;
            return this;
        }

        public Builder setUsePersistentConnections(boolean usePersistentConnections) {
            this.usePersistentConnections = usePersistentConnections;
            return this;
        }

        public Builder setConnectionIdleTimeout(int connectionIdleTimeout) {
            this.connectionIdleTimeout = connectionIdleTimeout;
            return this;
        }

        public Builder setWorkManagerSource(Supplier<Executor> workManagerSupplier) {
            this.workManagerSupplier = workManagerSupplier;
            return this;
        }

        public HttpServerConfiguration build() {
            return new HttpServerConfiguration(this.host, this.port, this.tlsContextFactory, this.usePersistentConnections, this.connectionIdleTimeout, this.workManagerSupplier);
        }
    }
}

