/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.listener;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import org.mule.extension.http.api.HttpStreamingType;
import org.mule.extension.http.api.listener.builder.HttpListenerResponseBuilder;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.MultiPartPayload;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.TransformationService;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.internal.transformer.simple.ObjectToByteArray;
import org.mule.runtime.core.model.ParameterMap;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.core.util.UUID;
import org.mule.runtime.module.http.api.HttpConstants;
import org.mule.runtime.module.http.api.HttpHeaders;
import org.mule.runtime.module.http.internal.HttpParser;
import org.mule.runtime.module.http.internal.domain.ByteArrayHttpEntity;
import org.mule.runtime.module.http.internal.domain.EmptyHttpEntity;
import org.mule.runtime.module.http.internal.domain.HttpEntity;
import org.mule.runtime.module.http.internal.domain.InputStreamHttpEntity;
import org.mule.runtime.module.http.internal.domain.MultipartHttpEntity;
import org.mule.runtime.module.http.internal.domain.response.HttpResponse;
import org.mule.runtime.module.http.internal.domain.response.HttpResponseBuilder;
import org.mule.runtime.module.http.internal.listener.HttpResponseHeaderBuilder;
import org.mule.runtime.module.http.internal.multipart.HttpMultipartEncoder;
import org.mule.runtime.module.http.internal.multipart.HttpPartDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseFactory {
    public static final String MULTIPART = "multipart";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private HttpStreamingType responseStreaming = HttpStreamingType.AUTO;
    private boolean multipartEntityWithNoMultipartContentyTypeWarned;
    private boolean mapPayloadButNoUrlEncodedContentTypeWarned;
    private TransformationService transformationService;
    private final Transformer objectToByteArray = new ObjectToByteArray();

    public HttpResponseFactory(HttpStreamingType responseStreaming, TransformationService transformationService) {
        this.responseStreaming = responseStreaming;
        this.transformationService = transformationService;
    }

    public HttpResponse create(HttpResponseBuilder responseBuilder, HttpListenerResponseBuilder listenerResponseBuilder, boolean supportsTransferEncoding) throws MessagingException {
        String reasonPhrase;
        ByteArrayHttpEntity byteArrayHttpEntity;
        HttpEntity httpEntity;
        Map<String, String> headers = listenerResponseBuilder.getHeaders();
        HttpResponseHeaderBuilder httpResponseHeaderBuilder = new HttpResponseHeaderBuilder();
        headers.forEach((key, value) -> {
            if ("Transfer-Encoding".equals(key) && !supportsTransferEncoding) {
                this.logger.debug("Client HTTP version is lower than 1.1 so the unsupported 'Transfer-Encoding' header has been removed and 'Content-Length' will be sent instead.");
            } else {
                httpResponseHeaderBuilder.addHeader((String)key, value);
            }
        });
        if (httpResponseHeaderBuilder.getContentType() == null && !MediaType.ANY.matches(listenerResponseBuilder.getMediaType())) {
            httpResponseHeaderBuilder.addHeader("Content-Type", listenerResponseBuilder.getMediaType().toString());
        }
        String configuredContentType = httpResponseHeaderBuilder.getContentType();
        String existingTransferEncoding = httpResponseHeaderBuilder.getTransferEncoding();
        String existingContentLength = httpResponseHeaderBuilder.getContentLength();
        Object payload = listenerResponseBuilder.getBody();
        if (payload == null) {
            this.setupContentLengthEncoding(httpResponseHeaderBuilder, 0);
            httpEntity = new EmptyHttpEntity();
        } else if (payload instanceof Map) {
            if (configuredContentType == null) {
                httpResponseHeaderBuilder.addContentType(HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED.toRfcString());
            } else if (!configuredContentType.startsWith(HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED.toRfcString())) {
                this.warnMapPayloadButNoUrlEncodedContentType(httpResponseHeaderBuilder.getContentType());
            }
            httpEntity = this.createUrlEncodedEntity(listenerResponseBuilder.getMediaType(), (Map)payload);
            if (this.responseStreaming == HttpStreamingType.ALWAYS && supportsTransferEncoding) {
                this.setupChunkedEncoding(httpResponseHeaderBuilder);
            } else if (httpEntity instanceof EmptyHttpEntity) {
                this.setupContentLengthEncoding(httpResponseHeaderBuilder, 0);
            } else {
                byteArrayHttpEntity = (ByteArrayHttpEntity)httpEntity;
                this.setupContentLengthEncoding(httpResponseHeaderBuilder, byteArrayHttpEntity.getContent().length);
            }
        } else if (payload instanceof MultiPartPayload) {
            if (configuredContentType == null) {
                httpResponseHeaderBuilder.addContentType(this.createMultipartFormDataContentType());
            } else if (!configuredContentType.startsWith(MULTIPART)) {
                this.warnNoMultipartContentTypeButMultipartEntity(httpResponseHeaderBuilder.getContentType());
            }
            httpEntity = this.createMultipartEntity(httpResponseHeaderBuilder.getContentType(), (MultiPartPayload)payload);
            this.resolveEncoding(httpResponseHeaderBuilder, existingTransferEncoding, existingContentLength, supportsTransferEncoding, (ByteArrayHttpEntity)httpEntity);
        } else if (payload instanceof InputStream) {
            if (this.responseStreaming == HttpStreamingType.ALWAYS || this.responseStreaming == HttpStreamingType.AUTO && existingContentLength == null) {
                if (supportsTransferEncoding) {
                    this.setupChunkedEncoding(httpResponseHeaderBuilder);
                }
                httpEntity = new InputStreamHttpEntity((InputStream)payload);
            } else {
                byteArrayHttpEntity = new ByteArrayHttpEntity(IOUtils.toByteArray((InputStream)((InputStream)payload)));
                this.setupContentLengthEncoding(httpResponseHeaderBuilder, byteArrayHttpEntity.getContent().length);
                httpEntity = byteArrayHttpEntity;
            }
        } else {
            byteArrayHttpEntity = new ByteArrayHttpEntity(this.getMessageAsBytes(payload));
            this.resolveEncoding(httpResponseHeaderBuilder, existingTransferEncoding, existingContentLength, supportsTransferEncoding, byteArrayHttpEntity);
            httpEntity = byteArrayHttpEntity;
        }
        Collection<String> headerNames = httpResponseHeaderBuilder.getHeaderNames();
        for (String headerName : headerNames) {
            Collection<String> values = httpResponseHeaderBuilder.getHeader(headerName);
            for (String value2 : values) {
                responseBuilder.addHeader(headerName, value2);
            }
        }
        Integer statusCode = listenerResponseBuilder.getStatusCode();
        if (statusCode != null) {
            responseBuilder.setStatusCode(statusCode);
        }
        if ((reasonPhrase = this.resolveReasonPhrase(listenerResponseBuilder.getReasonPhrase(), statusCode)) != null) {
            responseBuilder.setReasonPhrase(reasonPhrase);
        }
        responseBuilder.setEntity(httpEntity);
        return responseBuilder.build();
    }

    private byte[] getMessageAsBytes(Object payload) {
        try {
            return (byte[])this.transformationService.transform(InternalMessage.of((Object)payload), DataType.BYTE_ARRAY).getPayload().getValue();
        }
        catch (TransformerException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public String resolveReasonPhrase(String builderReasonPhrase, Integer statusCode) {
        String reasonPhrase = builderReasonPhrase;
        if (reasonPhrase == null && statusCode != null) {
            reasonPhrase = HttpConstants.HttpStatus.getReasonPhraseForStatusCode(statusCode);
        }
        return reasonPhrase;
    }

    private void resolveEncoding(HttpResponseHeaderBuilder httpResponseHeaderBuilder, String existingTransferEncoding, String existingContentLength, boolean supportsTransferEncoding, ByteArrayHttpEntity byteArrayHttpEntity) {
        if (this.responseStreaming == HttpStreamingType.ALWAYS || this.responseStreaming == HttpStreamingType.AUTO && existingContentLength == null && "chunked".equals(existingTransferEncoding)) {
            if (supportsTransferEncoding) {
                this.setupChunkedEncoding(httpResponseHeaderBuilder);
            }
        } else {
            this.setupContentLengthEncoding(httpResponseHeaderBuilder, byteArrayHttpEntity.getContent().length);
        }
    }

    private void setupContentLengthEncoding(HttpResponseHeaderBuilder httpResponseHeaderBuilder, int contentLength) {
        if (httpResponseHeaderBuilder.getTransferEncoding() != null) {
            this.logger.debug("Content-Length encoding is being used so the 'Transfer-Encoding' header has been removed");
            httpResponseHeaderBuilder.removeHeader("Transfer-Encoding");
        }
        httpResponseHeaderBuilder.setContentLenght(String.valueOf(contentLength));
    }

    private void setupChunkedEncoding(HttpResponseHeaderBuilder httpResponseHeaderBuilder) {
        if (httpResponseHeaderBuilder.getContentLength() != null) {
            this.logger.debug("Chunked encoding is being used so the 'Content-Length' header has been removed");
            httpResponseHeaderBuilder.removeHeader("Content-Length");
        }
        httpResponseHeaderBuilder.addHeader("Transfer-Encoding", "chunked");
    }

    private String createMultipartFormDataContentType() {
        return String.format("%s; boundary=%s", "multipart/form-data", UUID.getUUID());
    }

    private HttpEntity createUrlEncodedEntity(MediaType mediaType, Map payload) {
        Map mapPayload = payload;
        HttpEntity entity = new EmptyHttpEntity();
        if (!mapPayload.isEmpty()) {
            Charset encoding = (Charset)mediaType.getCharset().get();
            String encodedBody = mapPayload instanceof ParameterMap ? HttpParser.encodeString(encoding, ((ParameterMap)mapPayload).toListValuesMap()) : HttpParser.encodeString(encoding, mapPayload);
            entity = new ByteArrayHttpEntity(encodedBody.getBytes());
        }
        return entity;
    }

    private void warnMapPayloadButNoUrlEncodedContentType(String contentType) {
        if (!this.mapPayloadButNoUrlEncodedContentTypeWarned) {
            this.logger.warn(String.format("Payload is a Map which will be used to generate an url encoded http body but Contenty-Type specified is %s and not %s.", contentType, HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED));
            this.mapPayloadButNoUrlEncodedContentTypeWarned = true;
        }
    }

    private void warnNoMultipartContentTypeButMultipartEntity(String contentType) {
        if (!this.multipartEntityWithNoMultipartContentyTypeWarned) {
            this.logger.warn(String.format("Sending http response with Content-Type %s but the message has attachment and a multipart entity is generated.", contentType));
            this.multipartEntityWithNoMultipartContentyTypeWarned = true;
        }
    }

    private HttpEntity createMultipartEntity(String contentType, MultiPartPayload partPayload) throws MessagingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Message contains attachments. Ignoring payload and trying to generate multipart response.");
        }
        try {
            MultipartHttpEntity multipartEntity = new MultipartHttpEntity(HttpPartDataSource.createFrom(partPayload, this.objectToByteArray));
            return new ByteArrayHttpEntity(HttpMultipartEncoder.createMultipartContent(multipartEntity, contentType));
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Error creating multipart HTTP entity."), (Throwable)e);
        }
    }
}

