/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.listener;

import org.mule.extension.http.api.HttpStreamingType;
import org.mule.extension.http.api.listener.builder.HttpListenerSuccessResponseBuilder;
import org.mule.extension.http.internal.listener.HttpResponseContext;
import org.mule.extension.http.internal.listener.HttpResponseFactory;
import org.mule.runtime.core.TransformationService;
import org.mule.runtime.module.http.api.HttpConstants;
import org.mule.runtime.module.http.internal.domain.response.HttpResponse;
import org.mule.runtime.module.http.internal.domain.response.HttpResponseBuilder;
import org.mule.runtime.module.http.internal.listener.async.HttpResponseReadyCallback;
import org.mule.runtime.module.http.internal.listener.async.ResponseStatusCallback;

public class HttpListenerResponseSender {
    private final HttpResponseFactory responseFactory;

    public HttpListenerResponseSender(HttpResponseFactory responseFactory) {
        this.responseFactory = responseFactory;
    }

    public HttpListenerResponseSender(TransformationService transformationService) {
        this.responseFactory = new HttpResponseFactory(HttpStreamingType.NEVER, transformationService);
    }

    public void sendResponse(HttpResponseContext context, HttpListenerSuccessResponseBuilder responseBuilder) throws Exception {
        HttpResponse httpResponse = this.buildResponse(responseBuilder, context.isSupportStreaming());
        HttpResponseReadyCallback responseCallback = context.getResponseCallback();
        responseCallback.responseReady(httpResponse, this.getResponseFailureCallback(responseCallback));
    }

    protected HttpResponse buildResponse(HttpListenerSuccessResponseBuilder listenerResponseBuilder, boolean supportStreaming) throws Exception {
        HttpResponseBuilder responseBuilder = new HttpResponseBuilder();
        return this.doBuildResponse(responseBuilder, listenerResponseBuilder, supportStreaming);
    }

    protected HttpResponse doBuildResponse(HttpResponseBuilder responseBuilder, HttpListenerSuccessResponseBuilder listenerResponseBuilder, boolean supportsStreaming) throws Exception {
        return this.responseFactory.create(responseBuilder, listenerResponseBuilder, supportsStreaming);
    }

    private ResponseStatusCallback getResponseFailureCallback(final HttpResponseReadyCallback responseReadyCallback) {
        return new ResponseStatusCallback(){

            @Override
            public void responseSendFailure(Throwable throwable) {
                responseReadyCallback.responseReady(HttpListenerResponseSender.this.buildErrorResponse(), this);
            }

            @Override
            public void responseSendSuccessfully() {
            }
        };
    }

    protected HttpResponse buildErrorResponse() {
        HttpResponseBuilder errorResponseBuilder = new HttpResponseBuilder();
        HttpResponse errorResponse = errorResponseBuilder.setStatusCode(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode()).setReasonPhrase(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase()).build();
        return errorResponse;
    }
}

