/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.MimetypesFileTypeMap;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.core.util.StringUtils;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.module.http.internal.component.ResourceNotFoundException;

public class StaticResourceLoader {
    private static final String ANY_PATH = "/*";
    private static final String ROOT_PATH = "/";
    private static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private MimetypesFileTypeMap mimeTypes = new MimetypesFileTypeMap();
    @Parameter
    private String resourceBasePath;
    @Parameter
    @Optional(defaultValue="index.html")
    private String defaultFile;

    public InternalMessage load(Event event) throws ResourceNotFoundException {
        InternalMessage internalMessage;
        File file;
        Preconditions.checkArgument((boolean)(event.getMessage().getAttributes() instanceof HttpRequestAttributes), (String)"Message attributes must be HttpRequestAttributes.");
        HttpRequestAttributes attributes = (HttpRequestAttributes)event.getMessage().getAttributes();
        String path = attributes.getRequestPath();
        String contextPath = attributes.getListenerPath();
        if (contextPath.equals(ANY_PATH)) {
            contextPath = ROOT_PATH;
        }
        if (contextPath.endsWith(ANY_PATH)) {
            contextPath = StringUtils.removeEnd((String)contextPath, (String)ANY_PATH);
        }
        if (!ROOT_PATH.equals(contextPath)) {
            path = path.substring(contextPath.length());
        }
        if ((file = new File(this.resourceBasePath + path)).isDirectory()) {
            if (!path.endsWith(ROOT_PATH)) {
                path = path + ROOT_PATH;
            }
            file = new File(this.resourceBasePath + path + this.defaultFile);
        }
        FileInputStream in = null;
        try {
            InternalMessage result;
            in = new FileInputStream(file);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copyLarge((InputStream)in, (OutputStream)baos);
            byte[] buffer = baos.toByteArray();
            String mimeType = this.mimeTypes.getContentType(file);
            if (mimeType == null) {
                mimeType = DEFAULT_MIME_TYPE;
            }
            internalMessage = result = InternalMessage.builder().payload((Object)buffer).mediaType(MediaType.parse((String)mimeType)).build();
        }
        catch (IOException e) {
            try {
                throw new ResourceNotFoundException(I18nMessageFactory.createStaticMessage((String)String.format("The file: %s was not found.", this.resourceBasePath + path)), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return internalMessage;
    }
}

