/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal;

import java.util.Map;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.module.http.api.HttpParameters;
import org.mule.module.http.internal.HttpParam;
import org.mule.module.http.internal.HttpParamType;
import org.mule.module.http.internal.ParameterMap;

public class HttpMapParam
extends HttpParam {
    private String expression;

    public HttpMapParam(HttpParamType type) {
        super(type);
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    @Override
    public void resolve(ParameterMap parameterMap, MuleEvent muleEvent) {
        MuleContext muleContext = muleEvent.getMuleContext();
        Object expressionResult = muleContext.getExpressionManager().evaluate(this.expression, muleEvent);
        if (expressionResult instanceof HttpParameters) {
            HttpMapParam.resolveHttpParameters(parameterMap, (HttpParameters)expressionResult);
        } else {
            HttpMapParam.resolveMapObjObj(parameterMap, (Map)expressionResult);
        }
    }

    private static void resolveHttpParameters(ParameterMap parameterMap, HttpParameters expressionResult) {
        HttpParameters expressionHttpParameters = expressionResult;
        for (String key : expressionHttpParameters.keySet()) {
            for (String value : expressionHttpParameters.getAll(key)) {
                parameterMap.put(key, value);
            }
        }
    }

    private static void resolveMapObjObj(ParameterMap parameterMap, Map<Object, Object> expressionResult) {
        Map<Object, Object> expressionParamMap = expressionResult;
        for (Map.Entry<Object, Object> entry : expressionParamMap.entrySet()) {
            String paramName = entry.getKey().toString();
            Object paramValue = entry.getValue();
            if (paramValue instanceof Iterable) {
                for (Object value : (Iterable)paramValue) {
                    parameterMap.put(paramName, HttpMapParam.toStringIfPossible(value));
                }
                continue;
            }
            parameterMap.put(paramName, HttpMapParam.toStringIfPossible(paramValue));
        }
    }

    private static String toStringIfPossible(Object paramValue) {
        return paramValue != null ? paramValue.toString() : null;
    }
}

