/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.request;

import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.module.http.api.HttpAuthentication;
import org.mule.module.http.internal.domain.request.HttpRequestAuthentication;
import org.mule.module.http.internal.domain.request.HttpRequestBuilder;
import org.mule.module.http.internal.request.HttpAuthenticationType;
import org.mule.util.AttributeEvaluator;

public class DefaultHttpAuthentication
implements HttpAuthentication,
MuleContextAware,
Initialisable {
    private final HttpAuthenticationType type;
    private AttributeEvaluator username = new AttributeEvaluator(null);
    private AttributeEvaluator password = new AttributeEvaluator(null);
    private AttributeEvaluator domain = new AttributeEvaluator(null);
    private AttributeEvaluator workstation = new AttributeEvaluator(null);
    private AttributeEvaluator preemptive = new AttributeEvaluator(String.valueOf(false));
    private MuleContext muleContext;

    public DefaultHttpAuthentication(HttpAuthenticationType type) {
        this.type = type;
    }

    public void initialise() throws InitialisationException {
        this.username.initialize(this.muleContext.getExpressionManager());
        this.password.initialize(this.muleContext.getExpressionManager());
        this.domain.initialize(this.muleContext.getExpressionManager());
        this.workstation.initialize(this.muleContext.getExpressionManager());
        this.preemptive.initialize(this.muleContext.getExpressionManager());
    }

    public String getUsername() {
        return this.username.getRawValue();
    }

    public void setUsername(String username) {
        this.username = new AttributeEvaluator(username);
    }

    public String getPassword() {
        return this.password.getRawValue();
    }

    public void setPassword(String password) {
        this.password = new AttributeEvaluator(password);
    }

    public String getDomain() {
        return this.domain.getRawValue();
    }

    public void setDomain(String domain) {
        this.domain = new AttributeEvaluator(domain);
    }

    public HttpAuthenticationType getType() {
        return this.type;
    }

    public String getWorkstation() {
        return this.workstation.getRawValue();
    }

    public void setWorkstation(String workstation) {
        this.workstation = new AttributeEvaluator(workstation);
    }

    public String getPreemptive() {
        return this.preemptive.getRawValue();
    }

    public void setPreemptive(String preemptive) {
        this.preemptive = new AttributeEvaluator(preemptive);
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public HttpRequestAuthentication resolveRequestAuthentication(MuleEvent event) {
        HttpRequestAuthentication authentication = new HttpRequestAuthentication(this.type);
        authentication.setUsername(this.username.resolveStringValue(event));
        authentication.setPassword(this.password.resolveStringValue(event));
        authentication.setDomain(this.domain.resolveStringValue(event));
        authentication.setWorkstation(this.workstation.resolveStringValue(event));
        authentication.setPreemptive(this.preemptive.resolveBooleanValue(event));
        return authentication;
    }

    @Override
    public void authenticate(MuleEvent muleEvent, HttpRequestBuilder requestBuilder) {
    }

    @Override
    public boolean shouldRetry(MuleEvent firstAttemptResponseEvent) {
        return false;
    }
}

