/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.listener;

import com.google.common.net.MediaType;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import javax.activation.DataHandler;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.construct.FlowConstruct;
import org.mule.endpoint.URIBuilder;
import org.mule.module.http.internal.HttpParser;
import org.mule.module.http.internal.domain.EmptyHttpEntity;
import org.mule.module.http.internal.domain.HttpEntity;
import org.mule.module.http.internal.domain.HttpProtocol;
import org.mule.module.http.internal.domain.InputStreamHttpEntity;
import org.mule.module.http.internal.domain.MultipartHttpEntity;
import org.mule.module.http.internal.domain.request.HttpRequest;
import org.mule.module.http.internal.domain.request.HttpRequestContext;
import org.mule.module.http.internal.listener.HttpMessagePropertiesResolver;
import org.mule.module.http.internal.listener.HttpRequestParsingException;
import org.mule.module.http.internal.listener.ListenerPath;
import org.mule.module.http.internal.multipart.HttpPartDataSource;
import org.mule.session.DefaultMuleSession;
import org.mule.transport.NullPayload;
import org.mule.util.IOUtils;

public class HttpRequestToMuleEvent {
    public static MuleEvent transform(HttpRequestContext requestContext, MuleContext muleContext, FlowConstruct flowConstruct, Boolean parseRequest, ListenerPath listenerPath) throws HttpRequestParsingException {
        HttpRequest request = requestContext.getRequest();
        Collection<String> headerNames = request.getHeaderNames();
        HashMap<String, Object> inboundProperties = new HashMap<String, Object>();
        HashMap<String, String> outboundProperties = new HashMap<String, String>();
        for (String headerName : headerNames) {
            Collection<String> values = request.getHeaderValues(headerName);
            if (values.size() == 1) {
                inboundProperties.put(headerName, values.iterator().next());
                continue;
            }
            inboundProperties.put(headerName, values);
        }
        new HttpMessagePropertiesResolver().setMethod(request.getMethod()).setProtocol(request.getProtocol().asString()).setUri(request.getUri()).setListenerPath(listenerPath).setRemoteHostAddress(HttpRequestToMuleEvent.resolveRemoteHostAddress(requestContext)).setScheme(requestContext.getScheme()).setClientCertificate(requestContext.getClientConnection().getClientCertificate()).addPropertiesTo(inboundProperties);
        HashMap<String, DataHandler> inboundAttachments = new HashMap<String, DataHandler>();
        Object payload = NullPayload.getInstance();
        if (parseRequest.booleanValue()) {
            HttpEntity entity = request.getEntity();
            if (entity != null && !(entity instanceof EmptyHttpEntity)) {
                if (entity instanceof MultipartHttpEntity) {
                    inboundAttachments.putAll(HttpPartDataSource.createDataHandlerFrom(((MultipartHttpEntity)entity).getParts()));
                } else {
                    String contentTypeValue = request.getHeaderValue("Content-Type");
                    if (contentTypeValue != null) {
                        MediaType mediaType = MediaType.parse((String)contentTypeValue);
                        String encoding = mediaType.charset().isPresent() ? ((Charset)mediaType.charset().get()).name() : Charset.defaultCharset().name();
                        outboundProperties.put("MULE_ENCODING", encoding);
                        if ((mediaType.type() + "/" + mediaType.subtype()).equals("application/x-www-form-urlencoded")) {
                            try {
                                payload = HttpParser.decodeUrlEncodedBody(IOUtils.toString((InputStream)((InputStreamHttpEntity)entity).getInputStream()), encoding);
                            }
                            catch (IllegalArgumentException e) {
                                throw new HttpRequestParsingException("Cannot decode x-www-form-urlencoded payload", e);
                            }
                        } else if (entity instanceof InputStreamHttpEntity) {
                            payload = ((InputStreamHttpEntity)entity).getInputStream();
                        }
                    } else if (entity instanceof InputStreamHttpEntity) {
                        payload = ((InputStreamHttpEntity)entity).getInputStream();
                    }
                }
            }
        } else {
            InputStreamHttpEntity inputStreamEntity = request.getInputStreamEntity();
            if (inputStreamEntity != null) {
                payload = inputStreamEntity.getInputStream();
            }
        }
        DefaultMuleMessage defaultMuleMessage = new DefaultMuleMessage(payload, inboundProperties, outboundProperties, inboundAttachments, muleContext);
        return new DefaultMuleEvent((MuleMessage)defaultMuleMessage, HttpRequestToMuleEvent.resolveUri(requestContext), MessageExchangePattern.REQUEST_RESPONSE, flowConstruct, (MuleSession)new DefaultMuleSession());
    }

    private static URI resolveUri(HttpRequestContext requestContext) {
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.setProtocol(requestContext.getScheme());
        uriBuilder.setHost(HttpRequestToMuleEvent.resolveTargetHost(requestContext.getRequest()));
        uriBuilder.setPath(requestContext.getRequest().getPath());
        return uriBuilder.getEndpoint().getUri();
    }

    private static String resolveTargetHost(HttpRequest request) {
        String hostHeaderValue = request.getHeaderValue("host");
        if (HttpProtocol.HTTP_1_0.equals((Object)request.getProtocol()) || HttpProtocol.HTTP_0_9.equals((Object)request.getProtocol())) {
            return hostHeaderValue == null ? "0.0.0.0" : hostHeaderValue;
        }
        if (hostHeaderValue == null) {
            throw new IllegalArgumentException("Missing 'host' header");
        }
        return hostHeaderValue;
    }

    private static String resolveRemoteHostAddress(HttpRequestContext requestContext) {
        return requestContext.getClientConnection().getRemoteHostAddress().toString();
    }
}

