/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.request.grizzly;

import com.ning.http.client.providers.grizzly.TransportCustomizer;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.mule.transport.ssl.api.TlsContextFactory;

public class TlsTransportCustomizer
implements TransportCustomizer {
    private final TlsContextFactory tlsContextFactory;

    public TlsTransportCustomizer(TlsContextFactory tlsContextFactory) {
        this.tlsContextFactory = tlsContextFactory;
    }

    public void customize(TCPNIOTransport transport, FilterChainBuilder filterChainBuilder) {
        int index = filterChainBuilder.indexOfType(SSLFilter.class);
        if (index == -1) {
            return;
        }
        SSLFilter sslFilter = (SSLFilter)filterChainBuilder.get(index);
        String[] enabledCipherSuites = this.tlsContextFactory.getEnabledCipherSuites();
        String[] enabledProtocols = this.tlsContextFactory.getEnabledProtocols();
        if (enabledCipherSuites != null) {
            sslFilter.getClientSSLEngineConfigurator().setEnabledCipherSuites(enabledCipherSuites);
        }
        if (enabledProtocols != null) {
            sslFilter.getClientSSLEngineConfigurator().setEnabledProtocols(enabledProtocols);
        }
    }
}

