/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.request.grizzly;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.filter.FilterContext;
import com.ning.http.client.filter.FilterException;
import com.ning.http.client.filter.RequestFilter;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomTimeoutThrottleRequestFilter
implements RequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(CustomTimeoutThrottleRequestFilter.class);
    private final Semaphore available;

    public CustomTimeoutThrottleRequestFilter(int maxConnections) {
        this.available = new Semaphore(maxConnections, true);
    }

    public FilterContext filter(FilterContext ctx) throws FilterException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Current Throttling Status {}", (Object)this.available.availablePermits());
            }
            if (!this.available.tryAcquire(ctx.getRequest().getPerRequestConfig().getRequestTimeoutInMs(), TimeUnit.MILLISECONDS)) {
                throw new FilterException(String.format("No slot available for processing Request %s with AsyncHandler %s", ctx.getRequest(), ctx.getAsyncHandler()));
            }
        }
        catch (InterruptedException e) {
            throw new FilterException(String.format("Interrupted Request %s with AsyncHandler %s", ctx.getRequest(), ctx.getAsyncHandler()));
        }
        return new FilterContext.FilterContextBuilder(ctx).asyncHandler(new AsyncHandlerWrapper(ctx.getAsyncHandler())).build();
    }

    private class AsyncHandlerWrapper<T>
    implements AsyncHandler {
        private final AsyncHandler<T> asyncHandler;

        public AsyncHandlerWrapper(AsyncHandler<T> asyncHandler) {
            this.asyncHandler = asyncHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onThrowable(Throwable t) {
            try {
                this.asyncHandler.onThrowable(t);
            }
            finally {
                CustomTimeoutThrottleRequestFilter.this.available.release();
                if (logger.isDebugEnabled()) {
                    logger.debug("Current Throttling Status after onThrowable {}", (Object)CustomTimeoutThrottleRequestFilter.this.available.availablePermits());
                }
            }
        }

        public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
            return this.asyncHandler.onBodyPartReceived(bodyPart);
        }

        public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
            return this.asyncHandler.onStatusReceived(responseStatus);
        }

        public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
            return this.asyncHandler.onHeadersReceived(headers);
        }

        public T onCompleted() throws Exception {
            CustomTimeoutThrottleRequestFilter.this.available.release();
            if (logger.isDebugEnabled()) {
                logger.debug("Current Throttling Status {}", (Object)CustomTimeoutThrottleRequestFilter.this.available.availablePermits());
            }
            return (T)this.asyncHandler.onCompleted();
        }
    }
}

