/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.listener;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import org.mule.api.MuleContext;
import org.mule.api.MuleRuntimeException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.context.WorkManagerSource;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.http.internal.listener.HttpListenerRegistry;
import org.mule.module.http.internal.listener.HttpServerManager;
import org.mule.module.http.internal.listener.Server;
import org.mule.module.http.internal.listener.ServerAddress;
import org.mule.module.http.internal.listener.grizzly.GrizzlyServerManager;
import org.mule.transport.ssl.api.TlsContextFactory;
import org.mule.transport.tcp.DefaultTcpServerSocketProperties;
import org.mule.transport.tcp.TcpServerSocketProperties;
import org.mule.util.concurrent.ThreadNameHelper;

public class HttpListenerConnectionManager
implements Initialisable,
Disposable,
MuleContextAware {
    public static final String HTTP_LISTENER_CONNECTION_MANAGER = "_httpListenerConnectionManager";
    public static final String SERVER_ALREADY_EXISTS_FORMAT = "A server in port(%s) already exists for ip(%s) or one overlapping it (0.0.0.0).";
    private static final String LISTENER_THREAD_NAME_PREFIX = "http.listener";
    private HttpListenerRegistry httpListenerRegistry = new HttpListenerRegistry();
    private HttpServerManager httpServerManager;
    private MuleContext muleContext;

    public void initialise() throws InitialisationException {
        Collection tcpServerSocketPropertiesBeans = this.muleContext.getRegistry().lookupObjects(TcpServerSocketProperties.class);
        DefaultTcpServerSocketProperties tcpServerSocketProperties = new DefaultTcpServerSocketProperties();
        if (tcpServerSocketPropertiesBeans.size() == 1) {
            tcpServerSocketProperties = (TcpServerSocketProperties)Iterables.getOnlyElement((Iterable)tcpServerSocketPropertiesBeans);
        } else if (tcpServerSocketPropertiesBeans.size() > 1) {
            throw new InitialisationException(CoreMessages.createStaticMessage((String)"Only one global TCP server socket properties bean should be defined in the config"), (Initialisable)this);
        }
        String threadNamePrefix = ThreadNameHelper.getPrefix((MuleContext)this.muleContext) + LISTENER_THREAD_NAME_PREFIX;
        try {
            this.httpServerManager = new GrizzlyServerManager(threadNamePrefix, this.httpListenerRegistry, (TcpServerSocketProperties)tcpServerSocketProperties);
        }
        catch (IOException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public synchronized void dispose() {
        this.httpServerManager.dispose();
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public Server createServer(ServerAddress serverAddress, WorkManagerSource workManagerSource, boolean usePersistentConnections, int connectionIdleTimeout) {
        if (!this.httpServerManager.containsServerFor(serverAddress)) {
            try {
                return this.httpServerManager.createServerFor(serverAddress, workManagerSource, usePersistentConnections, connectionIdleTimeout);
            }
            catch (IOException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)String.format(SERVER_ALREADY_EXISTS_FORMAT, serverAddress.getPort(), serverAddress.getIp())));
    }

    public Server createSslServer(ServerAddress serverAddress, WorkManagerSource workManagerSource, TlsContextFactory tlsContext, boolean usePersistentConnections, int connectionIdleTimeout) {
        if (!this.httpServerManager.containsServerFor(serverAddress)) {
            try {
                return this.httpServerManager.createSslServerFor(tlsContext, workManagerSource, serverAddress, usePersistentConnections, connectionIdleTimeout);
            }
            catch (IOException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)String.format(SERVER_ALREADY_EXISTS_FORMAT, serverAddress.getPort(), serverAddress.getIp())));
    }
}

