/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.domain.response;

import java.util.Collection;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.mule.module.http.internal.domain.HttpEntity;
import org.mule.module.http.internal.domain.response.DefaultHttpResponse;
import org.mule.module.http.internal.domain.response.HttpResponse;
import org.mule.module.http.internal.domain.response.ResponseStatus;

public class HttpResponseBuilder {
    private MultiMap headers = new MultiValueMap();
    private ResponseStatus responseStatus = new ResponseStatus();
    private HttpEntity body;

    public HttpResponseBuilder addHeader(String name, Object value) {
        this.headers.put((Object)name, value);
        return this;
    }

    public HttpResponseBuilder setStatusCode(Integer statusCode) {
        this.responseStatus.setStatusCode(statusCode);
        return this;
    }

    public HttpResponseBuilder setReasonPhrase(String reasonPhrase) {
        this.responseStatus.setReasonPhrase(reasonPhrase);
        return this;
    }

    public String getFirstHeader(String headerName) {
        Object value = this.headers.get((Object)headerName);
        return (String)(value == null ? value : ((Collection)value).iterator().next());
    }

    public Collection<String> getHeader(String headerName) {
        return (Collection)this.headers.get((Object)headerName);
    }

    public HttpResponseBuilder setEntity(HttpEntity body) {
        this.body = body;
        return this;
    }

    public HttpResponse build() {
        return new DefaultHttpResponse(this.responseStatus, this.headers, this.body);
    }
}

