/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.request.grizzly;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.AsyncHttpProviderConfig;
import com.ning.http.client.BodyGenerator;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Part;
import com.ning.http.client.PerRequestConfig;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.SSLEngineFactory;
import com.ning.http.client.filter.RequestFilter;
import com.ning.http.client.generators.InputStreamBodyGenerator;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProviderConfig;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.http.api.HttpAuthentication;
import org.mule.module.http.internal.domain.ByteArrayHttpEntity;
import org.mule.module.http.internal.domain.InputStreamHttpEntity;
import org.mule.module.http.internal.domain.MultipartHttpEntity;
import org.mule.module.http.internal.domain.request.DefaultHttpRequest;
import org.mule.module.http.internal.domain.request.HttpRequest;
import org.mule.module.http.internal.domain.response.HttpResponse;
import org.mule.module.http.internal.domain.response.HttpResponseBuilder;
import org.mule.module.http.internal.request.DefaultHttpAuthentication;
import org.mule.module.http.internal.request.HttpAuthenticationType;
import org.mule.module.http.internal.request.HttpClient;
import org.mule.module.http.internal.request.NtlmProxyConfig;
import org.mule.module.http.internal.request.ProxyConfig;
import org.mule.module.http.internal.request.grizzly.CompositeTransportCustomizer;
import org.mule.module.http.internal.request.grizzly.CustomTimeoutThrottleRequestFilter;
import org.mule.module.http.internal.request.grizzly.GrizzlyHttpClientConfiguration;
import org.mule.module.http.internal.request.grizzly.PartWrapper;
import org.mule.module.http.internal.request.grizzly.SameThreadIOStrategyTransportCustomizer;
import org.mule.module.http.internal.request.grizzly.SocketConfigTransportCustomizer;
import org.mule.transport.ssl.api.TlsContextFactory;
import org.mule.transport.tcp.TcpClientSocketProperties;
import org.mule.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrizzlyHttpClient
implements HttpClient {
    private static final int MAX_CONNECTION_LIFETIME = 1800000;
    private static final Logger logger = LoggerFactory.getLogger(GrizzlyHttpClient.class);
    private final TlsContextFactory tlsContextFactory;
    private final ProxyConfig proxyConfig;
    private final TcpClientSocketProperties clientSocketProperties;
    private int maxConnections;
    private boolean usePersistentConnections;
    private int connectionIdleTimeout;
    private String threadNamePrefix;
    private AsyncHttpClient asyncHttpClient;
    private SSLContext sslContext;

    public GrizzlyHttpClient(GrizzlyHttpClientConfiguration config) {
        this.tlsContextFactory = config.getTlsContextFactory();
        this.proxyConfig = config.getProxyConfig();
        this.clientSocketProperties = config.getClientSocketProperties();
        this.maxConnections = config.getMaxConnections();
        this.usePersistentConnections = config.isUsePersistentConnections();
        this.connectionIdleTimeout = config.getConnectionIdleTimeout();
        this.threadNamePrefix = config.getThreadNamePrefix();
    }

    public void initialise() throws InitialisationException {
        AsyncHttpClientConfig.Builder builder = new AsyncHttpClientConfig.Builder();
        builder.setAllowPoolingConnection(true);
        builder.setRemoveQueryParamsOnRedirect(false);
        this.configureTransport(builder);
        this.configureTlsContext(builder);
        this.configureProxy(builder);
        this.configureConnections(builder);
        AsyncHttpClientConfig config = builder.build();
        this.asyncHttpClient = new AsyncHttpClient((AsyncHttpProvider)new GrizzlyAsyncHttpProvider(config), config);
    }

    private void configureTlsContext(AsyncHttpClientConfig.Builder builder) throws InitialisationException {
        if (this.tlsContextFactory != null) {
            try {
                this.sslContext = this.tlsContextFactory.createSslContext();
            }
            catch (Exception e) {
                throw new InitialisationException(CoreMessages.createStaticMessage((String)"Cannot initialize SSL context"), (Throwable)e, (Initialisable)this);
            }
            builder.setSSLEngineFactory(new SSLEngineFactory(){

                public SSLEngine newSSLEngine() throws GeneralSecurityException {
                    SSLEngine sslEngine = GrizzlyHttpClient.this.sslContext.createSSLEngine();
                    sslEngine.setEnabledCipherSuites(GrizzlyHttpClient.this.tlsContextFactory.getEnabledCipherSuites());
                    sslEngine.setEnabledProtocols(GrizzlyHttpClient.this.tlsContextFactory.getEnabledProtocols());
                    return sslEngine;
                }
            });
        }
    }

    private void configureProxy(AsyncHttpClientConfig.Builder builder) {
        if (this.proxyConfig != null) {
            ProxyServer proxyServer;
            if (!StringUtils.isEmpty((String)this.proxyConfig.getUsername())) {
                proxyServer = new ProxyServer(this.proxyConfig.getHost(), Integer.parseInt(this.proxyConfig.getPort()), this.proxyConfig.getUsername(), this.proxyConfig.getPassword());
                if (this.proxyConfig instanceof NtlmProxyConfig) {
                    proxyServer.setNtlmDomain(((NtlmProxyConfig)this.proxyConfig).getNtlmDomain());
                }
            } else {
                proxyServer = new ProxyServer(this.proxyConfig.getHost(), Integer.parseInt(this.proxyConfig.getPort()));
            }
            builder.setProxyServer(proxyServer);
        }
    }

    private void configureTransport(AsyncHttpClientConfig.Builder builder) {
        GrizzlyAsyncHttpProviderConfig providerConfig = new GrizzlyAsyncHttpProviderConfig();
        CompositeTransportCustomizer compositeTransportCustomizer = new CompositeTransportCustomizer();
        compositeTransportCustomizer.addTransportCustomizer(new SameThreadIOStrategyTransportCustomizer(this.threadNamePrefix));
        if (this.clientSocketProperties != null) {
            compositeTransportCustomizer.addTransportCustomizer(new SocketConfigTransportCustomizer(this.clientSocketProperties));
        }
        providerConfig.addProperty(GrizzlyAsyncHttpProviderConfig.Property.TRANSPORT_CUSTOMIZER, (Object)compositeTransportCustomizer);
        builder.setAsyncHttpClientProviderConfig((AsyncHttpProviderConfig)providerConfig);
    }

    private void configureConnections(AsyncHttpClientConfig.Builder builder) throws InitialisationException {
        if (this.maxConnections > 0) {
            builder.addRequestFilter((RequestFilter)new CustomTimeoutThrottleRequestFilter(this.maxConnections));
        }
        builder.setMaximumConnectionsTotal(this.maxConnections);
        builder.setMaximumConnectionsPerHost(this.maxConnections);
        builder.setAllowPoolingConnection(this.usePersistentConnections);
        builder.setAllowSslConnectionPool(this.usePersistentConnections);
        builder.setMaxConnectionLifeTimeInMs(1800000);
        builder.setIdleConnectionInPoolTimeoutInMs(this.connectionIdleTimeout);
    }

    @Override
    public HttpResponse send(HttpRequest request, int responseTimeout, boolean followRedirects, HttpAuthentication authentication) throws IOException, TimeoutException {
        RequestBuilder builder = new RequestBuilder();
        builder.setMethod(request.getMethod());
        builder.setUrl(this.encodePath(request.getUri()));
        builder.setFollowRedirects(followRedirects);
        for (String headerName : request.getHeaderNames()) {
            for (String headerValue : request.getHeaderValues(headerName)) {
                builder.addHeader(headerName, headerValue);
            }
        }
        DefaultHttpRequest defaultHttpRequest = (DefaultHttpRequest)request;
        for (String queryParamName : defaultHttpRequest.getQueryParams().keySet()) {
            for (String queryParamValue : defaultHttpRequest.getQueryParams().getAll(queryParamName)) {
                builder.addQueryParameter(queryParamName, queryParamValue);
            }
        }
        if (authentication != null && authentication instanceof DefaultHttpAuthentication) {
            DefaultHttpAuthentication defaultHttpAuthentication = (DefaultHttpAuthentication)authentication;
            Realm.RealmBuilder realmBuilder = new Realm.RealmBuilder().setPrincipal(defaultHttpAuthentication.getUsername()).setPassword(defaultHttpAuthentication.getPassword()).setUsePreemptiveAuth(false);
            if (defaultHttpAuthentication.getType() == HttpAuthenticationType.BASIC) {
                realmBuilder.setScheme(Realm.AuthScheme.BASIC);
            } else if (defaultHttpAuthentication.getType() == HttpAuthenticationType.DIGEST) {
                realmBuilder.setScheme(Realm.AuthScheme.DIGEST);
            }
            builder.setRealm(realmBuilder.build());
        }
        if (request.getEntity() != null) {
            if (request.getEntity() instanceof InputStreamHttpEntity) {
                builder.setBody((BodyGenerator)new InputStreamBodyGenerator(((InputStreamHttpEntity)request.getEntity()).getInputStream()));
            } else if (request.getEntity() instanceof ByteArrayHttpEntity) {
                builder.setBody(((ByteArrayHttpEntity)request.getEntity()).getContent());
            } else if (request.getEntity() instanceof MultipartHttpEntity) {
                MultipartHttpEntity multipartHttpEntity = (MultipartHttpEntity)request.getEntity();
                for (javax.servlet.http.Part part : multipartHttpEntity.getParts()) {
                    builder.addBodyPart((Part)new PartWrapper(part));
                }
            }
        }
        builder.setPerRequestConfig(new PerRequestConfig(null, responseTimeout));
        ListenableFuture future = this.asyncHttpClient.executeRequest(builder.build());
        Response response = null;
        try {
            response = (Response)future.get((long)responseTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
        HttpResponseBuilder responseBuilder = new HttpResponseBuilder();
        responseBuilder.setStatusCode(response.getStatusCode());
        responseBuilder.setReasonPhrase(response.getStatusText());
        responseBuilder.setEntity(new InputStreamHttpEntity(response.getResponseBodyAsStream()));
        for (String header : response.getHeaders().keySet()) {
            for (String headerValue : response.getHeaders(header)) {
                responseBuilder.addHeader(header, headerValue);
            }
        }
        return responseBuilder.build();
    }

    private String encodePath(String uri) {
        URI originalUri = URI.create(uri);
        try {
            URI encodedUri = new URI(originalUri.getScheme(), originalUri.getUserInfo(), originalUri.getHost(), originalUri.getPort(), originalUri.getRawPath(), originalUri.getQuery(), originalUri.getFragment());
            return encodedUri.toString();
        }
        catch (URISyntaxException e) {
            logger.warn("Could not encode request URI", (Throwable)e);
            return uri;
        }
    }

    public void stop() {
        this.asyncHttpClient.close();
    }
}

