/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.guice;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.guiceyfruit.mule.MuleModule;
import org.mule.api.MuleContext;
import org.mule.api.config.ConfigurationException;
import org.mule.api.registry.Registry;
import org.mule.config.builders.AbstractConfigurationBuilder;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.guice.AbstractMuleGuiceModule;
import org.mule.module.guice.GuiceModuleFactory;
import org.mule.module.guice.GuiceRegistry;
import org.mule.module.guice.MuleSupportModule;
import org.mule.util.ClassUtils;
import org.mule.util.scan.ClasspathScanner;

@Deprecated
public class GuiceConfigurationBuilder
extends AbstractConfigurationBuilder {
    public static final String DEFAULT_PACKAGE = "";
    protected String basepath = "";
    protected Module[] modules = null;
    protected Stage stage;
    protected ClassLoader classLoader;

    public GuiceConfigurationBuilder() {
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    public GuiceConfigurationBuilder(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public GuiceConfigurationBuilder(String basepath) {
        this();
        this.basepath = basepath;
    }

    public GuiceConfigurationBuilder(String basepath, ClassLoader classLoader) {
        this.basepath = basepath;
        this.classLoader = classLoader;
    }

    public GuiceConfigurationBuilder(Module ... modules) {
        this.modules = modules;
    }

    public GuiceConfigurationBuilder(Stage stage, Module ... modules) {
        this.stage = stage;
        this.modules = modules;
    }

    protected void doConfigure(MuleContext muleContext) throws Exception {
        List<Module> allModules = this.getSystemModules(muleContext);
        if (this.basepath != null && this.basepath.startsWith("/")) {
            this.basepath = this.basepath.substring(1);
        }
        if (this.modules == null) {
            ClasspathScanner scanner = new ClasspathScanner(this.classLoader, new String[]{this.basepath});
            Set classes = scanner.scanFor(Module.class);
            Set factories = scanner.scanFor(GuiceModuleFactory.class);
            if (classes.size() == 0 && factories.size() == 0) {
                try {
                    this.basepath = ((Object)((Object)this)).getClass().getClassLoader().getResources(this.basepath).toString();
                }
                catch (Exception e) {
                    this.basepath = this.basepath.equals(DEFAULT_PACKAGE) ? "/" : this.basepath;
                }
                this.logger.warn((Object)new ConfigurationException(CoreMessages.createStaticMessage((String)("There are no Guice modules or module factories on the classpath under: " + this.basepath))));
                return;
            }
            for (Class moduleClass : classes) {
                allModules.add((Module)ClassUtils.instanciateClass((Class)moduleClass, (Object[])ClassUtils.NO_ARGS));
            }
            for (Class factoryClass : factories) {
                GuiceModuleFactory factory = (GuiceModuleFactory)ClassUtils.instanciateClass((Class)factoryClass, (Object[])ClassUtils.NO_ARGS);
                allModules.add(factory.createModule());
            }
        } else {
            allModules.addAll(Arrays.asList(this.modules));
        }
        for (Module module : allModules) {
            if (!(module instanceof AbstractMuleGuiceModule)) continue;
            ((AbstractMuleGuiceModule)module).setMuleContext(muleContext);
        }
        Injector injector = this.stage != null ? Guice.createInjector((Stage)this.stage, allModules) : Guice.createInjector(allModules);
        GuiceRegistry registry = new GuiceRegistry(injector, muleContext);
        registry.initialise();
        muleContext.addRegistry((Registry)registry);
    }

    protected List<Module> getSystemModules(MuleContext muleContext) {
        ArrayList<Module> systemModules = new ArrayList<Module>();
        systemModules.add((Module)new MuleModule());
        systemModules.add((Module)new MuleSupportModule(muleContext));
        return systemModules;
    }
}

