/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth.processor;

import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.config.i18n.MessageFactory;
import org.mule.security.oauth.OAuth1Adapter;
import org.mule.security.oauth.processor.FetchAccessTokenMessageProcessor;

public class OAuth1FetchAccessTokenMessageProcessor
extends FetchAccessTokenMessageProcessor {
    private String authorizationUrl = null;
    private String requestTokenUrl = null;
    private OAuth1Adapter adapter = null;

    public OAuth1FetchAccessTokenMessageProcessor(OAuth1Adapter adapter) {
        this.adapter = adapter;
    }

    @Override
    protected final MuleEvent doProcess(MuleEvent event) throws Exception {
        this.notifyCallbackReception(event);
        try {
            this.adapter.setOauthVerifier((String)event.getMessage().getInvocationProperty("_oauthVerifier"));
            this.adapter.fetchAccessToken(this.requestTokenUrl, this.getAccessTokenUrl(), this.authorizationUrl, this.getRedirectUri());
        }
        catch (Exception e) {
            throw new MessagingException(MessageFactory.createStaticMessage((String)"Unable to fetch access token"), event, (Throwable)e);
        }
        return event;
    }

    public void setAuthorizationUrl(String value) {
        this.authorizationUrl = value;
    }

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public void setRequestTokenUrl(String value) {
        this.requestTokenUrl = value;
    }

    public String getRequestTokenUrl() {
        return this.requestTokenUrl;
    }
}

