/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.config.domain.query;

import java.util.Arrays;
import java.util.List;
import org.mule.config.spring.parsers.AbstractMuleBeanDefinitionParser;
import org.mule.module.db.internal.config.domain.param.InputParamDefinitionDefinitionParser;
import org.mule.module.db.internal.config.domain.query.DynamicQueryTemplateFactoryBean;
import org.mule.module.db.internal.config.domain.query.ParameterizedQueryTemplateFactoryBean;
import org.mule.module.db.internal.config.domain.query.QueryDefinitionParser;
import org.mule.module.db.internal.config.domain.query.QueryFileFactoryBean;
import org.mule.module.db.internal.config.domain.query.QueryTemplateFactoryBean;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.parser.SimpleQueryTemplateParser;
import org.mule.module.db.internal.util.DefaultFileReader;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class QueryTemplateBeanDefinitionParser
extends AbstractMuleBeanDefinitionParser {
    public static final String PARAMETERIZED_QUERY = "parameterized-query";
    public static final String DYNAMIC_QUERY = "dynamic-query";
    public static final String TEMPLATE_QUERY_REF = "template-query-ref";
    public static final String IN_PARAM_ELEMENT = "in-param";
    public static final String FILE_ATTRIBUTE = "file";
    public static final String[] QUERY_DEFINITION_ELEMENTS = new String[]{"parameterized-query", "dynamic-query", "template-query-ref"};

    protected Class<?> getBeanClass(Element element) {
        return QueryTemplate.class;
    }

    protected boolean isSingleton() {
        return true;
    }

    protected void doParse(Element element, ParserContext context, BeanDefinitionBuilder builder) {
        builder.setScope(this.isSingleton() ? "singleton" : "prototype");
        ParserContext nestedCtx = new ParserContext(context.getReaderContext(), context.getDelegate(), (BeanDefinition)builder.getBeanDefinition());
        Element sqlElem = DomUtils.getChildElementByTagName((Element)element, (String)PARAMETERIZED_QUERY);
        if (sqlElem != null) {
            this.parseParameterizedQuery(element, builder, nestedCtx, sqlElem);
        } else {
            sqlElem = DomUtils.getChildElementByTagName((Element)element, (String)DYNAMIC_QUERY);
            if (sqlElem != null) {
                this.parseDynamicQuery(element, builder, sqlElem);
            } else {
                sqlElem = DomUtils.getChildElementByTagName((Element)element, (String)TEMPLATE_QUERY_REF);
                if (sqlElem != null) {
                    this.parseQueryTemplateRef(element, builder, nestedCtx, sqlElem);
                } else {
                    throw new IllegalArgumentException("Template must contain one of the following elements: " + Arrays.toString(QUERY_DEFINITION_ELEMENTS));
                }
            }
        }
    }

    private void parseDynamicQuery(Element element, BeanDefinitionBuilder builder, Element sqlElem) {
        BeanDefinitionBuilder queryTemplateFactory = BeanDefinitionBuilder.genericBeanDefinition(DynamicQueryTemplateFactoryBean.class);
        queryTemplateFactory.addConstructorArgValue((Object)sqlElem.getTextContent());
        builder.addConstructorArgValue((Object)queryTemplateFactory.getBeanDefinition());
        element.removeChild(sqlElem);
    }

    private void parseQueryTemplateRef(Element element, BeanDefinitionBuilder builder, ParserContext nestedCtx, Element template) {
        String queryTemplateRef = template.getAttribute("name");
        element.removeChild(template);
        List params = DomUtils.getChildElementsByTagName((Element)element, (String)IN_PARAM_ELEMENT);
        List<BeanDefinition> paramList = QueryDefinitionParser.parseOverriddenTemplateParameters(params, nestedCtx);
        BeanDefinitionBuilder queryTemplateBuilder = BeanDefinitionBuilder.genericBeanDefinition(QueryTemplateFactoryBean.class);
        queryTemplateBuilder.addConstructorArgReference(queryTemplateRef);
        queryTemplateBuilder.addConstructorArgValue(paramList);
        builder.addConstructorArgValue((Object)queryTemplateBuilder.getBeanDefinition());
    }

    private void parseParameterizedQuery(Element element, BeanDefinitionBuilder builder, ParserContext nestedCtx, Element sqlElem) {
        boolean hasTextContent;
        boolean hasFileAttribute = sqlElem.hasAttribute(FILE_ATTRIBUTE);
        boolean bl = hasTextContent = !element.getTextContent().trim().isEmpty();
        if (hasFileAttribute && hasTextContent) {
            throw new IllegalArgumentException(String.format("Element %s cannot contain attribute file and text content simultaneously", element.getTagName()));
        }
        BeanDefinitionBuilder queryTemplateFactory = BeanDefinitionBuilder.genericBeanDefinition(ParameterizedQueryTemplateFactoryBean.class);
        if (hasFileAttribute) {
            String fileName = sqlElem.getAttribute(FILE_ATTRIBUTE);
            BeanDefinitionBuilder queryFileBuilder = BeanDefinitionBuilder.genericBeanDefinition(QueryFileFactoryBean.class);
            queryFileBuilder.addConstructorArgValue((Object)fileName);
            queryFileBuilder.addConstructorArgValue((Object)new DefaultFileReader());
            queryTemplateFactory.addConstructorArgValue((Object)queryFileBuilder.getBeanDefinition());
        } else {
            Node node = sqlElem.getFirstChild();
            String sqlText = node.getNextSibling() != null && node.getNextSibling().getNodeType() == 4 ? node.getNextSibling().getNodeValue() : node.getNodeValue();
            queryTemplateFactory.addConstructorArgValue((Object)sqlText);
        }
        element.removeChild(sqlElem);
        ManagedList params = new ManagedList();
        List childElementsByTagName = DomUtils.getChildElementsByTagName((Element)element, (String)IN_PARAM_ELEMENT);
        for (Element param : childElementsByTagName) {
            BeanDefinition paramBean = this.parseParameter(nestedCtx, param);
            params.add(paramBean);
        }
        queryTemplateFactory.addConstructorArgValue((Object)params);
        queryTemplateFactory.addConstructorArgValue((Object)new SimpleQueryTemplateParser());
        builder.addConstructorArgValue((Object)queryTemplateFactory.getBeanDefinition());
    }

    private BeanDefinition parseParameter(ParserContext nestedCtx, Element param) {
        InputParamDefinitionDefinitionParser paramParser = new InputParamDefinitionDefinitionParser();
        return paramParser.parse(param, nestedCtx);
    }
}

