/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.config.domain.database;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.mule.module.db.internal.config.domain.database.DbConfigFactoryBean;
import org.mule.util.StringUtils;

public abstract class AbstractVendorConfigFactoryBean
extends DbConfigFactoryBean {
    private String host;
    private int port = -1;
    private String urlPrefix;
    private String database;

    protected AbstractVendorConfigFactoryBean(String urlPrefix) {
        this.urlPrefix = urlPrefix;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUrlPrefix() {
        return this.urlPrefix;
    }

    @Override
    protected String getEffectiveUrl() {
        String url = this.getUrl();
        if (StringUtils.isEmpty((String)url)) {
            url = this.buildUrlFromAttributes();
        }
        return this.addProperties(url);
    }

    protected String buildUrlFromAttributes() {
        StringBuilder buf = new StringBuilder(128);
        buf.append(this.getUrlPrefix());
        buf.append(this.getHost());
        if (this.getPort() > 0) {
            buf.append(":");
            buf.append(this.getPort());
        }
        buf.append("/");
        buf.append(this.getDatabase());
        String url = buf.toString();
        return url;
    }

    private String addProperties(String url) {
        Map<String, String> connectionProperties = this.getConnectionProperties();
        if (connectionProperties.isEmpty()) {
            return url;
        }
        StringBuilder effectiveUrl = new StringBuilder(url);
        if (this.getUri(url).getQuery() == null) {
            effectiveUrl.append("?");
        } else {
            effectiveUrl.append("&");
        }
        return effectiveUrl.append(this.buildQueryParams(connectionProperties)).toString();
    }

    private String buildQueryParams(Map<String, String> connectionProperties) {
        StringBuilder params = new StringBuilder(128);
        for (Map.Entry<String, String> entry : connectionProperties.entrySet()) {
            if (params.length() > 0) {
                params.append('&');
            }
            params.append(entry.getKey()).append('=').append(entry.getValue());
        }
        return params.toString();
    }

    private URI getUri(String url) {
        try {
            return new URI(url.substring(5));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to parse database config URL", e);
        }
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }
}

