/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.sqlexecutor.statement;

import java.sql.SQLException;
import java.sql.Statement;
import org.mule.module.db.sqlexecutor.command.SqlCommandDefinition;
import org.mule.module.db.sqlexecutor.command.SqlCommandType;
import org.mule.module.db.sqlexecutor.connection.DbConnection;
import org.mule.module.db.sqlexecutor.executor.AutoGeneratedKey;
import org.mule.module.db.sqlexecutor.executor.ColumnIndexAutoGeneratedKey;
import org.mule.module.db.sqlexecutor.executor.ColumnNameAutoGeneratedKey;
import org.mule.module.db.sqlexecutor.executor.DefaultAutoGeneratedKey;
import org.mule.module.db.sqlexecutor.executor.NoAutoGeneratedKey;
import org.mule.module.db.sqlexecutor.statement.ConfigurableStatementFactory;

public class SimpleStatementFactory
implements ConfigurableStatementFactory {
    private int maxRows;

    @Override
    public Statement create(DbConnection connection, SqlCommandDefinition sqlCommandDefinition) throws SQLException {
        return this.create(connection, sqlCommandDefinition, new NoAutoGeneratedKey());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Statement create(DbConnection connection, SqlCommandDefinition sqlCommandDefinition, AutoGeneratedKey autoGeneratedKey) throws SQLException {
        Statement result;
        if (sqlCommandDefinition.getType().equals((Object)SqlCommandType.STORE_PROCEDURE_CALL)) {
            result = connection.prepareCall(sqlCommandDefinition.getSqlText(), 1005, 1007);
        } else {
            boolean hasInputParams;
            boolean bl = hasInputParams = sqlCommandDefinition.getInputParams().size() > 0;
            if (hasInputParams) {
                if (autoGeneratedKey instanceof NoAutoGeneratedKey) {
                    result = connection.prepareStatement(sqlCommandDefinition.getSqlText());
                } else if (autoGeneratedKey instanceof DefaultAutoGeneratedKey) {
                    result = connection.prepareStatement(sqlCommandDefinition.getSqlText(), 1);
                } else if (autoGeneratedKey instanceof ColumnIndexAutoGeneratedKey) {
                    result = connection.prepareStatement(sqlCommandDefinition.getSqlText(), ((ColumnIndexAutoGeneratedKey)autoGeneratedKey).getColumnIndexes());
                } else {
                    if (!(autoGeneratedKey instanceof ColumnNameAutoGeneratedKey)) throw new IllegalArgumentException();
                    result = connection.prepareStatement(sqlCommandDefinition.getSqlText(), ((ColumnNameAutoGeneratedKey)autoGeneratedKey).getColumnNames());
                }
            } else {
                result = connection.createStatement();
            }
        }
        if (this.maxRows <= 0) return result;
        result.setMaxRows(this.maxRows);
        return result;
    }

    @Override
    public void setMaxRows(int max) {
        this.maxRows = max;
    }
}

