/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.sqlexecutor.resulthandler;

import java.sql.Statement;
import java.util.HashMap;
import org.mule.module.db.sqlexecutor.command.SqlCommandDefinition;
import org.mule.module.db.sqlexecutor.connection.DbConnection;
import org.mule.module.db.sqlexecutor.executor.AutoGeneratedKey;
import org.mule.module.db.sqlexecutor.resulthandler.ResultSetHandler;
import org.mule.module.db.sqlexecutor.resulthandler.StatementResult;
import org.mule.module.db.sqlexecutor.resulthandler.StatementResultHandler;
import org.mule.module.db.sqlexecutor.resulthandler.StatementResultIterator;
import org.mule.module.db.sqlexecutor.resulthandler.StatementResultIteratorFactory;

public class MapStatementResultHandler
implements StatementResultHandler {
    private final ResultSetHandler resultSetHandler;

    public MapStatementResultHandler(ResultSetHandler resultSetHandler) {
        this.resultSetHandler = resultSetHandler;
    }

    @Override
    public Object processStatement(DbConnection connection, Statement statement, SqlCommandDefinition sqlCommandDefinition, AutoGeneratedKey autoGeneratedKey) {
        StatementResultIteratorFactory statementResultIteratorFactory = connection.getStatementResultIteratorFactory(this.resultSetHandler);
        StatementResultIterator statementResultIterator = statementResultIteratorFactory.create(connection, statement, sqlCommandDefinition, autoGeneratedKey);
        HashMap<String, Object> result = new HashMap<String, Object>();
        while (statementResultIterator.hasNext()) {
            StatementResult next = statementResultIterator.next();
            result.put(next.getName(), next.getResult());
        }
        return result;
    }
}

