/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.sqlexecutor.executor;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.mule.module.db.sqlexecutor.command.SqlCommand;
import org.mule.module.db.sqlexecutor.connection.DbConnection;
import org.mule.module.db.sqlexecutor.executor.AbstractExecutor;
import org.mule.module.db.sqlexecutor.executor.AutoGeneratedKey;
import org.mule.module.db.sqlexecutor.resulthandler.ResultSetHandler;
import org.mule.module.db.sqlexecutor.statement.SqlStatementFactory;

public class QueryExecutor
extends AbstractExecutor {
    private final ResultSetHandler resultHandler;

    public QueryExecutor(SqlStatementFactory statementFactory, ResultSetHandler resultHandler) {
        super(statementFactory);
        this.resultHandler = resultHandler;
    }

    @Override
    protected Object executeSqlCommand(DbConnection connection, Statement statement, SqlCommand sqlCommand) throws SQLException {
        ResultSet resultSet;
        if (statement instanceof PreparedStatement) {
            this.doProcessParameters((PreparedStatement)statement, sqlCommand.getSqlCommandDefinition().getParams(), sqlCommand.getParamValues());
            resultSet = ((PreparedStatement)statement).executeQuery();
        } else {
            resultSet = statement.executeQuery(sqlCommand.getSqlCommandDefinition().getSqlText());
        }
        return this.resultHandler.processResultSet(connection, resultSet);
    }

    @Override
    protected Object executeSqlCommand(DbConnection connection, Statement statement, SqlCommand sqlCommand, AutoGeneratedKey autoGeneratedKey) throws SQLException {
        return this.executeSqlCommand(connection, statement, sqlCommand);
    }
}

