/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.sqlexecutor.executor;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.module.db.sqlexecutor.command.InputSqlParamValue;
import org.mule.module.db.sqlexecutor.command.SqlCommand;
import org.mule.module.db.sqlexecutor.connection.DbConnection;
import org.mule.module.db.sqlexecutor.executor.AutoGeneratedKey;
import org.mule.module.db.sqlexecutor.executor.CommandExecutor;
import org.mule.module.db.sqlexecutor.param.InputSqlParam;
import org.mule.module.db.sqlexecutor.param.OutputSqlParam;
import org.mule.module.db.sqlexecutor.param.SqlParam;
import org.mule.module.db.sqlexecutor.statement.SqlStatementFactory;
import org.mule.module.db.sqlexecutor.type.DbType;

public abstract class AbstractExecutor
implements CommandExecutor {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final SqlStatementFactory statementFactory;

    public AbstractExecutor(SqlStatementFactory statementFactory) {
        this.statementFactory = statementFactory;
    }

    @Override
    public Object execute(DbConnection connection, SqlCommand sqlCommand) throws SQLException {
        Statement statement = this.statementFactory.create(connection, sqlCommand.getSqlCommandDefinition());
        return this.executeSqlCommand(connection, statement, sqlCommand);
    }

    @Override
    public Object execute(DbConnection connection, SqlCommand sqlCommand, AutoGeneratedKey autoGeneratedKey) throws SQLException {
        Statement statement = this.statementFactory.create(connection, sqlCommand.getSqlCommandDefinition(), autoGeneratedKey);
        return this.executeSqlCommand(connection, statement, sqlCommand, autoGeneratedKey);
    }

    protected abstract Object executeSqlCommand(DbConnection var1, Statement var2, SqlCommand var3) throws SQLException;

    protected abstract Object executeSqlCommand(DbConnection var1, Statement var2, SqlCommand var3, AutoGeneratedKey var4) throws SQLException;

    protected void doProcessParameters(PreparedStatement statement, List<SqlParam> params, List<InputSqlParamValue> paramValues) throws SQLException {
        int inputParamsSize = params.size();
        for (int index = 1; index <= inputParamsSize; ++index) {
            SqlParam sqlParam = params.get(index - 1);
            if (sqlParam instanceof InputSqlParam) {
                InputSqlParamValue param = paramValues.get(index - 1);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)String.format("Adding parameter: '%s' with value: '%s'", index, param.getValue()));
                }
                this.processInputParam(statement, index, param.getValue(), sqlParam.getType());
            }
            if (!(sqlParam instanceof OutputSqlParam)) continue;
            this.processOutputParam((CallableStatement)statement, index, sqlParam.getType());
        }
    }

    protected void processInputParam(PreparedStatement statement, int index, Object value, DbType type) throws SQLException {
        type.setParameterValue(statement, index, value);
    }

    private void processOutputParam(CallableStatement statement, int index, DbType type) throws SQLException {
        type.registerOutParameter(statement, index);
    }
}

