/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.sqlexecutor.connection;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.module.db.sqlexecutor.command.SqlCommandDefinition;
import org.mule.module.db.sqlexecutor.connection.DbConnection;
import org.mule.module.db.sqlexecutor.connection.DbTypeResolver;
import org.mule.module.db.sqlexecutor.type.AbstractDbType;
import org.mule.module.db.sqlexecutor.type.DbType;
import org.mule.module.db.sqlexecutor.type.DbTypeManager;
import org.mule.module.db.sqlexecutor.type.TypeDoesNotExistsException;

public class MetadataTypeResolver
implements DbTypeResolver {
    private static final Log logger = LogFactory.getLog(MetadataTypeResolver.class);
    private final DbTypeManager dbTypeManager;

    public MetadataTypeResolver(DbTypeManager dbTypeManager) {
        this.dbTypeManager = dbTypeManager;
    }

    @Override
    public Map<Integer, DbType> getParameterTypes(DbConnection connection, SqlCommandDefinition commandDefinition) throws SQLException {
        HashMap<Integer, DbType> paramTypes = new HashMap<Integer, DbType>();
        DatabaseMetaData dbMetaData = connection.getMetaData();
        String storedProcedureName = this.getStoredProcedureName(dbMetaData, commandDefinition.getSqlText());
        ResultSet procedureColumns = dbMetaData.getProcedureColumns(connection.getCatalog(), null, storedProcedureName, "%");
        int position = 1;
        while (procedureColumns.next()) {
            DbType dbType;
            int typeId = procedureColumns.getInt(6);
            String typeName = procedureColumns.getString(7);
            if (logger.isDebugEnabled()) {
                String name = procedureColumns.getString(4);
                logger.debug((Object)String.format("Resolved parameter type: Store procedure: %s Name: %s Index: %s Type ID: %s Type Name: %s", storedProcedureName, name, position, typeId, typeName));
            }
            try {
                dbType = this.dbTypeManager.get(typeId, typeName);
            }
            catch (TypeDoesNotExistsException e) {
                dbType = new AbstractDbType(typeId, typeName, null, null);
            }
            paramTypes.put(position, dbType);
            ++position;
        }
        return paramTypes;
    }

    private String getStoredProcedureName(DatabaseMetaData dbMetaData, String sqlText) throws SQLException {
        int parenthesisIndex;
        String upperCaseSql = sqlText.toUpperCase();
        int spaceIndex = upperCaseSql.indexOf("CALL") + 4;
        while (upperCaseSql.charAt(spaceIndex) == ' ') {
            ++spaceIndex;
        }
        for (parenthesisIndex = spaceIndex + 1; parenthesisIndex < upperCaseSql.length() && upperCaseSql.charAt(parenthesisIndex) != '('; ++parenthesisIndex) {
        }
        if (parenthesisIndex >= upperCaseSql.length()) {
            throw new SQLException("Invalid stored procedure call: " + sqlText);
        }
        String storedProcedureName = sqlText.substring(spaceIndex, parenthesisIndex);
        if (dbMetaData.storesUpperCaseIdentifiers()) {
            return storedProcedureName.toUpperCase();
        }
        return storedProcedureName;
    }
}

