/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.config;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.mule.config.spring.parsers.AbstractMuleBeanDefinitionParser;
import org.mule.module.db.config.CommandDefinitionFactoryBean;
import org.mule.module.db.config.InputParamDefinitionDefinitionParser;
import org.mule.module.db.config.ParameterizedQueryDefinitionParser;
import org.mule.module.db.sqlexecutor.command.SqlCommandDefinition;
import org.mule.module.db.sqlexecutor.command.SqlCommandType;
import org.mule.module.db.sqlexecutor.param.InputSqlParam;
import org.mule.module.db.sqlexecutor.parser.SimpleSqlCommandParser;
import org.mule.util.IOUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TemplateQueryBeanDefinitionParser
extends AbstractMuleBeanDefinitionParser {
    public static final String PARAMETERIZED_QUERY = "parameterized-query";
    public static final String DYNAMIC_QUERY = "dynamic-query";
    public static final String TEMPLATE_QUERY_REF = "template-query-ref";
    public static final String IN_PARAM_ELEMENT = "in-param";
    public static final String FILE_ATTRIBUTE = "file";
    public static final String[] QUERY_DEFINITION_ELEMENTS = new String[]{"parameterized-query", "dynamic-query", "template-query-ref"};

    protected Class<?> getBeanClass(Element element) {
        return SqlCommandDefinition.class;
    }

    protected boolean isSingleton() {
        return true;
    }

    protected void doParse(Element element, ParserContext context, BeanDefinitionBuilder builder) {
        builder.setScope(this.isSingleton() ? "singleton" : "prototype");
        ParserContext nestedCtx = new ParserContext(context.getReaderContext(), context.getDelegate(), (BeanDefinition)builder.getBeanDefinition());
        Element sqlElem = DomUtils.getChildElementByTagName((Element)element, (String)PARAMETERIZED_QUERY);
        if (sqlElem != null) {
            this.parseSqlDefinition(element, builder, nestedCtx, sqlElem);
        } else {
            sqlElem = DomUtils.getChildElementByTagName((Element)element, (String)DYNAMIC_QUERY);
            if (sqlElem != null) {
                this.parseDynamicQuery(element, builder, nestedCtx, sqlElem);
            } else {
                sqlElem = DomUtils.getChildElementByTagName((Element)element, (String)TEMPLATE_QUERY_REF);
                if (sqlElem != null) {
                    this.parseSqlReference(element, builder, nestedCtx, sqlElem);
                } else {
                    throw new IllegalArgumentException("Template must contain one of the following elements: " + Arrays.toString(QUERY_DEFINITION_ELEMENTS));
                }
            }
        }
    }

    private void parseDynamicQuery(Element element, BeanDefinitionBuilder builder, ParserContext nestedCtx, Element sqlElem) {
        String sqlText = sqlElem.getTextContent();
        SqlCommandDefinition sqlCommandDefinition = new SqlCommandDefinition(sqlText, SqlCommandType.DDL, Collections.EMPTY_LIST, true);
        builder.addConstructorArgValue((Object)sqlCommandDefinition);
        element.removeChild(sqlElem);
    }

    private void parseSqlReference(Element element, BeanDefinitionBuilder builder, ParserContext nestedCtx, Element template) {
        String commandDefRef = template.getAttribute("name");
        element.removeChild(template);
        List params = DomUtils.getChildElementsByTagName((Element)element, (String)IN_PARAM_ELEMENT);
        List<BeanDefinition> paramList = ParameterizedQueryDefinitionParser.parseParameterValues(params, nestedCtx);
        BeanDefinitionBuilder queryFactoryBean = BeanDefinitionBuilder.genericBeanDefinition(CommandDefinitionFactoryBean.class);
        queryFactoryBean.addConstructorArgReference(commandDefRef);
        queryFactoryBean.addConstructorArgValue(paramList);
        builder.addConstructorArgValue((Object)queryFactoryBean.getBeanDefinition());
    }

    private void parseSqlDefinition(Element element, BeanDefinitionBuilder builder, ParserContext nestedCtx, Element sqlElem) {
        String sqlText;
        boolean hasTextContent;
        NodeList childNodes = sqlElem.getChildNodes();
        boolean hasFileAttribute = sqlElem.hasAttribute(FILE_ATTRIBUTE);
        boolean bl = hasTextContent = !element.getTextContent().isEmpty();
        if (hasFileAttribute && hasTextContent) {
            throw new IllegalArgumentException(String.format("Element %s cannot contain attribute file and text content simultaneously", element.getTagName()));
        }
        if (hasFileAttribute) {
            String fileName = sqlElem.getAttribute(FILE_ATTRIBUTE);
            try {
                sqlText = IOUtils.getResourceAsString((String)fileName, ((Object)((Object)this)).getClass());
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to read query from file: " + fileName);
            }
        } else {
            sqlText = childNodes.item(0).getNodeValue();
        }
        SimpleSqlCommandParser simpleSqlCommandParser = new SimpleSqlCommandParser();
        SqlCommandDefinition commandDefinition = simpleSqlCommandParser.parse(sqlText);
        if (sqlText.contains("#[")) {
            builder.addConstructorArgValue((Object)commandDefinition);
            element.removeChild(sqlElem);
        } else {
            builder.addConstructorArgValue((Object)commandDefinition.getSqlText());
            builder.addConstructorArgValue((Object)commandDefinition.getType());
            element.removeChild(sqlElem);
            ManagedList params = new ManagedList();
            List childElementsByTagName = DomUtils.getChildElementsByTagName((Element)element, (String)IN_PARAM_ELEMENT);
            if (commandDefinition.usesNamedParameters()) {
                for (InputSqlParam inputSqlParam : commandDefinition.getInputParams()) {
                    Element param = this.findOverriddenParamElement(inputSqlParam.getName(), childElementsByTagName);
                    if (param == null) {
                        params.add(inputSqlParam);
                        continue;
                    }
                    BeanDefinition paramBean = this.parseParameter(nestedCtx, param);
                    params.add(paramBean);
                }
            } else {
                for (Element param : childElementsByTagName) {
                    BeanDefinition paramBean = this.parseParameter(nestedCtx, param);
                    params.add(paramBean);
                }
            }
            builder.addConstructorArgValue((Object)params);
        }
    }

    private BeanDefinition parseParameter(ParserContext nestedCtx, Element param) {
        InputParamDefinitionDefinitionParser paramParser = new InputParamDefinitionDefinitionParser();
        return paramParser.parse(param, nestedCtx);
    }

    private Element findOverriddenParamElement(String name, List<Element> paramElements) {
        if (name != null) {
            for (Element paramElement : paramElements) {
                if (!paramElement.hasAttribute("name") || !name.equals(paramElement.getAttribute("name"))) continue;
                return paramElement;
            }
        }
        return null;
    }
}

