/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.config;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.mule.module.db.sqlexecutor.command.InputSqlParamValue;
import org.mule.module.db.sqlexecutor.command.SqlCommandDefinition;
import org.mule.module.db.sqlexecutor.param.DefaultInputSqlParam;
import org.mule.module.db.sqlexecutor.param.InputSqlParam;
import org.mule.module.db.sqlexecutor.param.SqlParam;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class CommandDefinitionFactoryBean
extends AbstractFactoryBean<SqlCommandDefinition> {
    private final SqlCommandDefinition commandDefinition;
    private final List<InputSqlParamValue> params;

    public CommandDefinitionFactoryBean(SqlCommandDefinition commandDefinition, List<InputSqlParamValue> params) {
        this.commandDefinition = commandDefinition;
        this.params = params != null ? params : Collections.emptyList();
    }

    public Class<?> getObjectType() {
        return SqlCommandDefinition.class;
    }

    protected SqlCommandDefinition createInstance() throws Exception {
        if (this.params.isEmpty()) {
            return this.commandDefinition;
        }
        LinkedList<SqlParam> paramDefinitions = new LinkedList<SqlParam>();
        boolean usesNameParamOverride = this.usesNamedParamOverride();
        if (usesNameParamOverride) {
            this.processNameParamOverride(paramDefinitions);
        }
        return new SqlCommandDefinition(this.commandDefinition.getSqlText(), this.commandDefinition.getType(), paramDefinitions);
    }

    private void processNameParamOverride(List<SqlParam> paramDefinitions) {
        for (InputSqlParam param : this.commandDefinition.getInputParams()) {
            InputSqlParamValue inputSqlParamValue = this.getOverriddenParam(param.getName());
            Object value = inputSqlParamValue != null ? inputSqlParamValue.getValue() : param.getValue();
            DefaultInputSqlParam newParam = new DefaultInputSqlParam(param.getIndex(), param.getType(), value, param.getName());
            paramDefinitions.add(newParam);
        }
    }

    private InputSqlParamValue getOverriddenParam(String name) {
        for (InputSqlParamValue param : this.params) {
            if (!name.equals(param.getName())) continue;
            return param;
        }
        return null;
    }

    private boolean usesNamedParamOverride() {
        boolean result = false;
        for (InputSqlParamValue param : this.params) {
            if (param.getName() == null || "".equals(param.getName())) continue;
            result = true;
            break;
        }
        return result;
    }
}

