/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.springframework.core.io.AbstractResource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class ServletContextOrClassPathResource
extends AbstractResource {
    private final ServletContext servletContext;
    private final String path;

    public ServletContextOrClassPathResource(ServletContext servletContext, String path) {
        Assert.notNull((Object)servletContext, (String)"Cannot resolve ServletContextResource without ServletContext");
        this.servletContext = servletContext;
        Assert.notNull((Object)path, (String)"path is required");
        this.path = StringUtils.cleanPath((String)path);
    }

    public InputStream getInputStream() throws IOException {
        InputStream is = this.getServletContextInputStream();
        if (is == null) {
            is = this.getClasspathInputStream();
        }
        if (is == null) {
            throw new FileNotFoundException(this.getDescription() + " cannot be opened because it does not exist");
        }
        return is;
    }

    protected InputStream getServletContextInputStream() {
        String servletContextPath = this.path;
        if (!servletContextPath.startsWith("/")) {
            servletContextPath = "/" + servletContextPath;
        }
        return this.servletContext.getResourceAsStream(servletContextPath);
    }

    protected InputStream getClasspathInputStream() {
        String classpathPath = this.path;
        if (classpathPath.startsWith("/")) {
            classpathPath = classpathPath.substring(1);
        }
        return ClassUtils.getDefaultClassLoader().getResourceAsStream(classpathPath);
    }

    public String getDescription() {
        return this.path;
    }
}

