/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.ConfigurationException;
import org.mule.config.builders.MuleXmlConfigurationBuilder;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.FileUtils;
import org.mule.util.IOUtils;

public class WebappMuleXmlConfigurationBuilder
extends MuleXmlConfigurationBuilder {
    protected final transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private ServletContext context;
    private String webappClasspath;

    public WebappMuleXmlConfigurationBuilder(ServletContext context, String webappClasspath) throws ConfigurationException {
        this.context = context;
        this.webappClasspath = webappClasspath;
    }

    protected InputStream loadConfig(String configResource) throws ConfigurationException {
        String resourcePath = configResource;
        InputStream is = null;
        if (this.webappClasspath != null) {
            resourcePath = new File(this.webappClasspath, configResource).getPath();
            is = this.context.getResourceAsStream(resourcePath);
        }
        if (is == null) {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(configResource);
        }
        if (this.logger.isDebugEnabled()) {
            if (is != null) {
                this.logger.debug((Object)("Resource " + configResource + " is found in Servlet Context."));
            } else {
                this.logger.debug((Object)("Resource " + resourcePath + " is not found in Servlet Context, loading from classpath or as external file"));
            }
        }
        if (is == null && this.webappClasspath != null) {
            resourcePath = FileUtils.newFile((String)this.webappClasspath, (String)configResource).getPath();
            try {
                is = IOUtils.getResourceAsStream((String)resourcePath, ((Object)((Object)this)).getClass());
            }
            catch (IOException ex) {
                this.logger.debug((Object)("Resource " + resourcePath + " is not found in filesystem " + ex));
            }
        }
        if (is == null) {
            try {
                this.logger.debug((Object)("Resource " + resourcePath + " not found in Servlet Context, loading from classpath"));
                is = IOUtils.getResourceAsStream((String)configResource, ((Object)((Object)this)).getClass());
            }
            catch (IOException ioex) {
                throw new ConfigurationException(CoreMessages.cannotLoadFromClasspath((String)configResource), (Throwable)ioex);
            }
        }
        return is;
    }
}

