/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.ConfigurationException;
import org.mule.config.builders.MuleXmlConfigurationBuilder;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.IOUtils;

public class WebappMuleXmlConfigurationBuilder
extends MuleXmlConfigurationBuilder {
    protected final transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private ServletContext context;
    private String webappClasspath;

    public WebappMuleXmlConfigurationBuilder(ServletContext context, String webappClasspath) throws ConfigurationException {
        this.context = context;
        this.webappClasspath = webappClasspath;
    }

    protected InputStream loadResource(String resource) throws ConfigurationException {
        String resourcePath = resource;
        InputStream is = null;
        if (this.webappClasspath != null) {
            resourcePath = new File(this.webappClasspath, resource).getPath();
            is = this.context.getResourceAsStream(resourcePath);
        }
        if (is == null) {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
        }
        if (this.logger.isDebugEnabled() && is != null) {
            this.logger.debug((Object)("Resource " + resource + " is found in Servlet Context."));
        }
        if (is == null) {
            try {
                this.logger.debug((Object)("Resource " + resourcePath + " not found in Servlet Context, loading from classpath"));
                is = IOUtils.getResourceAsStream((String)resource, ((Object)((Object)this)).getClass());
            }
            catch (IOException ioex) {
                throw new ConfigurationException(CoreMessages.cannotLoadFromClasspath((String)resource), (Throwable)ioex);
            }
        }
        return is;
    }
}

