/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.bpm;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.RequestContext;
import org.mule.VoidMuleEvent;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointCache;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.PropertyScope;
import org.mule.config.i18n.MessageFactory;
import org.mule.endpoint.SimpleEndpointCache;
import org.mule.module.bpm.BPMS;
import org.mule.module.bpm.MessageService;
import org.mule.transport.NullPayload;
import org.mule.util.StringUtils;

public class Process
implements Initialisable,
Disposable,
MessageService {
    private final BPMS bpms;
    private final String name;
    private final String resource;
    protected final String processIdField;
    protected MuleContext muleContext;
    private FlowConstruct flowConstruct;
    public static final String BPM_PROPERTY_PREFIX = "BPM_";
    public static final String PROPERTY_ENDPOINT = "MULE_BPM_ENDPOINT";
    public static final String PROPERTY_PROCESS_TYPE = "MULE_BPM_PROCESS_TYPE";
    public static final String PROPERTY_PROCESS_ID = "MULE_BPM_PROCESS_ID";
    public static final String PROPERTY_ACTION = "MULE_BPM_ACTION";
    public static final String PROPERTY_TRANSITION = "MULE_BPM_TRANSITION";
    public static final String PROPERTY_PROCESS_STARTED = "MULE_BPM_STARTED";
    public static final String ACTION_START = "start";
    public static final String ACTION_ADVANCE = "advance";
    public static final String ACTION_UPDATE = "update";
    public static final String ACTION_ABORT = "abort";
    public static final String PROCESS_VARIABLE_INCOMING = "incoming";
    public static final String PROCESS_VARIABLE_INCOMING_SOURCE = "incomingSource";
    public static final String PROCESS_VARIABLE_DATA = "data";
    protected static final Log logger = LogFactory.getLog(Process.class);
    private final EndpointCache endpointCache;

    public Process(BPMS bpms, String name, String resource, FlowConstruct flowConstruct, MuleContext muleContext) {
        this(bpms, name, resource, null, flowConstruct, muleContext);
    }

    public Process(BPMS bpms, String name, String resource, String processIdField, FlowConstruct flowConstruct, MuleContext muleContext) {
        this.bpms = bpms;
        this.name = name;
        this.resource = resource;
        this.processIdField = processIdField;
        this.flowConstruct = flowConstruct;
        this.muleContext = muleContext;
        this.endpointCache = new SimpleEndpointCache(muleContext);
    }

    public void initialise() throws InitialisationException {
        try {
            this.bpms.deployProcess(this.resource);
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public void dispose() {
        try {
            this.bpms.undeployProcess(this.resource);
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object handleEvent(MuleEvent event) throws Exception {
        Object process;
        Object processId;
        String processIdField;
        HashMap<String, Object> processVariables = new HashMap<String, Object>();
        if (event != null && !VoidMuleEvent.getInstance().equals(event)) {
            this.populateProcessVariables(event, processVariables, PropertyScope.INVOCATION);
            this.populateProcessVariables(event, processVariables, PropertyScope.INBOUND);
            Object payload = event.getMessage().getPayload();
            if (payload != null && !(payload instanceof NullPayload)) {
                processVariables.put(PROCESS_VARIABLE_INCOMING, payload);
                String originatingEndpoint = (String)event.getMessage().getInboundProperty("MULE_ORIGINATING_ENDPOINT");
                if (StringUtils.isNotEmpty((String)originatingEndpoint)) {
                    processVariables.put(PROCESS_VARIABLE_INCOMING_SOURCE, originatingEndpoint);
                }
            }
        }
        if (StringUtils.isEmpty((String)(processIdField = this.getProcessIdField()))) {
            processIdField = PROPERTY_PROCESS_ID;
        }
        if ((processId = event.getMessage().getSessionProperty(processIdField)) == null) {
            processId = event.getMessage().getInvocationProperty(processIdField);
        }
        if (processId == null) {
            processId = event.getMessage().getInboundProperty(processIdField);
        }
        processVariables.remove(processIdField);
        String action = (String)event.getMessage().getInvocationProperty(PROPERTY_ACTION, (Object)ACTION_ADVANCE);
        processVariables.remove(PROPERTY_ACTION);
        Object transition = event.getMessage().getInvocationProperty(PROPERTY_TRANSITION);
        processVariables.remove(PROPERTY_TRANSITION);
        logger.debug((Object)("Message received: payload = " + event.getMessage().getPayload().getClass().getName() + " processType = " + this.name + " processId = " + processId + " action = " + action));
        if (processId == null || action.equals(ACTION_START)) {
            process = this.getBpms().startProcess(this.name, transition, processVariables);
            if (process == null || !logger.isInfoEnabled()) return process;
            logger.info((Object)("New process started, ID = " + this.getBpms().getId(process)));
            return process;
        } else if (action.equals(ACTION_UPDATE)) {
            if (processId == null) throw new IllegalArgumentException("Process ID is missing, cannot update process.");
            process = this.getBpms().updateProcess(processId, processVariables);
            if (process == null || !logger.isInfoEnabled()) return process;
            logger.info((Object)("Process variables updated, ID = " + this.getBpms().getId(process)));
            return process;
        } else if (action.equals(ACTION_ABORT)) {
            if (processId == null) throw new IllegalArgumentException("Process ID is missing, cannot abort process.");
            this.getBpms().abortProcess(processId);
            process = NullPayload.getInstance();
            logger.info((Object)("Process aborted, ID = " + processId));
            return process;
        } else {
            if (processId == null) throw new IllegalArgumentException("Process ID is missing, cannot advance process.");
            process = this.getBpms().advanceProcess(processId, transition, processVariables);
            if (process == null || !logger.isInfoEnabled()) return process;
            logger.info((Object)("Process advanced, ID = " + this.getBpms().getId(process) + ", new state = " + this.getBpms().getState(process)));
        }
        return process;
    }

    protected void populateProcessVariables(MuleEvent event, Map processVariables, PropertyScope propertyScope) {
        for (String propertyName : event.getMessage().getPropertyNames(propertyScope)) {
            if (propertyName.equals("MULE_SESSION")) continue;
            processVariables.put(propertyName, event.getMessage().getProperty(propertyName, propertyScope));
        }
    }

    @Override
    public MuleMessage generateMessage(String endpoint, Object payload, Map messageProperties, MessageExchangePattern exchangePattern) throws MuleException {
        Object message = payload instanceof MuleMessage ? (MuleMessage)payload : new DefaultMuleMessage(payload, this.muleContext);
        message.addProperties(messageProperties, PropertyScope.OUTBOUND);
        message.addProperties(messageProperties, PropertyScope.INVOCATION);
        OutboundEndpoint ep = this.endpointCache.getOutboundEndpoint(endpoint, exchangePattern, null);
        DefaultMuleEvent event = new DefaultMuleEvent(message, ep.getExchangePattern(), this.flowConstruct);
        RequestContext.setEvent((MuleEvent)event);
        if (messageProperties.get(PROPERTY_PROCESS_TYPE) != null) {
            event.getMessage().setSessionProperty(PROPERTY_PROCESS_TYPE, messageProperties.get(PROPERTY_PROCESS_TYPE));
        }
        if (messageProperties.get(PROPERTY_PROCESS_ID) != null) {
            event.getMessage().setSessionProperty(PROPERTY_PROCESS_ID, messageProperties.get(PROPERTY_PROCESS_ID));
        }
        MuleEvent resultEvent = ep.process((MuleEvent)event);
        MuleMessage response = null;
        if (resultEvent != null && !VoidMuleEvent.getInstance().equals(resultEvent) && (response = resultEvent.getMessage()).getExceptionPayload() != null) {
            throw new DispatchException(MessageFactory.createStaticMessage((String)"Unable to send or route message"), (MuleEvent)event, (MessageProcessor)ep, response.getExceptionPayload().getRootException());
        }
        return response;
    }

    public String getProcessIdField() {
        return this.processIdField;
    }

    public BPMS getBpms() {
        return this.bpms;
    }

    public String getResource() {
        return this.resource;
    }

    public String getName() {
        return this.name;
    }
}

