/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.boot;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import org.mule.module.boot.DefaultMuleClassPathConfig;
import org.mule.module.boot.MuleBootstrap;

public final class MuleBootstrapUtils {
    private static final String MULE_LIB_FILENAME = "lib" + File.separator + "mule";
    private static final String MULE_HOME = System.getProperty("mule.home");
    public static final String MULE_LOCAL_JAR_FILENAME = "mule-local-install.jar";

    private MuleBootstrapUtils() {
    }

    public static File getMuleHomeFile() {
        return new File(MULE_HOME);
    }

    public static File getMuleLibDir() {
        return new File(MULE_HOME + File.separator + MULE_LIB_FILENAME);
    }

    public static File getMuleLocalJarFile() {
        return new File(MuleBootstrapUtils.getMuleLibDir(), MULE_LOCAL_JAR_FILENAME);
    }

    public static void addLocalJarFilesToClasspath(File muleHome, File muleBase) throws Exception {
        DefaultMuleClassPathConfig classPath = new DefaultMuleClassPathConfig(muleHome, muleBase);
        MuleBootstrapUtils.addLibrariesToClasspath(classPath.getURLs());
    }

    public static void addLibrariesToClasspath(List urls) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ClassLoader sys = ClassLoader.getSystemClassLoader();
        if (!(sys instanceof URLClassLoader)) {
            throw new IllegalArgumentException("PANIC: Mule has been started with an unsupported classloader: " + sys.getClass().getName() + ". " + "Please report this error to user<at>mule<dot>codehaus<dot>org");
        }
        URLClassLoader sysCl = (URLClassLoader)sys;
        Class<URLClassLoader> refClass = URLClassLoader.class;
        Method methodAddUrl = refClass.getDeclaredMethod("addURL", URL.class);
        methodAddUrl.setAccessible(true);
        for (URL url : urls) {
            methodAddUrl.invoke((Object)sysCl, url);
        }
    }

    public static URL getResource(final String resourceName, final Class callingClass) {
        URL url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                return cl != null ? cl.getResource(resourceName) : null;
            }
        });
        if (url == null) {
            url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return MuleBootstrap.class.getClassLoader().getResource(resourceName);
                }
            });
        }
        if (url == null) {
            url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return callingClass.getClassLoader().getResource(resourceName);
                }
            });
        }
        return url;
    }

    public static boolean renameFile(File srcFile, File destFile) throws IOException {
        boolean isRenamed = false;
        if (srcFile != null && destFile != null && !destFile.exists() && srcFile.isFile() && !(isRenamed = srcFile.renameTo(destFile)) && srcFile.exists()) {
            isRenamed = MuleBootstrapUtils.renameFileHard(srcFile, destFile);
        }
        return isRenamed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean renameFileHard(File srcFile, File destFile) throws IOException {
        boolean isRenamed = false;
        if (srcFile != null && destFile != null && !destFile.exists() && srcFile.isFile()) {
            FileInputStream in = null;
            FileOutputStream out = null;
            try {
                in = new FileInputStream(srcFile);
                out = new FileOutputStream(destFile);
                out.getChannel().transferFrom(in.getChannel(), 0L, srcFile.length());
                isRenamed = true;
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            if (isRenamed) {
                srcFile.delete();
            } else {
                destFile.delete();
            }
        }
        return isRenamed;
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        long count = MuleBootstrapUtils.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static class ProxyInfo {
        String host;
        String port;
        String username;
        String password;

        public ProxyInfo(String host, String port) {
            this(host, port, null, null);
        }

        public ProxyInfo(String host, String port, String username, String password) {
            this.host = host;
            this.port = port;
            this.username = username;
            this.password = password;
        }
    }
}

