/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.source.MessageSource;
import org.mule.module.apikit.exception.ApikitRuntimeException;
import org.mule.module.http.internal.listener.DefaultHttpListener;
import org.mule.module.http.internal.listener.DefaultHttpListenerConfig;

public class MessageSourceAdapter {
    private IMessageSource delegate;

    public MessageSourceAdapter(MessageSource messageSource) {
        if (messageSource instanceof ImmutableEndpoint) {
            this.delegate = new MessageSourceEndpointAdapter((ImmutableEndpoint)messageSource);
        } else if (messageSource instanceof DefaultHttpListener) {
            this.delegate = new MessageSourceListenerAdapter((DefaultHttpListener)messageSource);
        } else {
            throw new ApikitRuntimeException("Message Source Type NOT SUPPORTED: " + messageSource.getClass());
        }
    }

    public String getAddress() {
        return this.delegate.getAddress();
    }

    public String getPath() {
        return this.delegate.getPath();
    }

    public String getScheme() {
        return this.delegate.getScheme();
    }

    private class MessageSourceListenerAdapter
    implements IMessageSource {
        private DefaultHttpListener listener;
        private DefaultHttpListenerConfig config;

        public MessageSourceListenerAdapter(DefaultHttpListener messageSource) {
            this.listener = messageSource;
            this.config = (DefaultHttpListenerConfig)messageSource.getConfig();
        }

        @Override
        public String getAddress() {
            return String.format("%s://%s:%s%s", this.getScheme(), this.config.getHost(), this.config.getPort(), this.getPath());
        }

        @Override
        public String getPath() {
            String path = this.listener.getPath();
            return path.endsWith("/*") ? path.substring(0, path.length() - 2) : path;
        }

        @Override
        public String getScheme() {
            return this.config.getTlsContext() != null ? "https" : "http";
        }
    }

    private class MessageSourceEndpointAdapter
    implements IMessageSource {
        private ImmutableEndpoint endpoint;

        public MessageSourceEndpointAdapter(ImmutableEndpoint messageSource) {
            this.endpoint = messageSource;
        }

        @Override
        public String getAddress() {
            return this.endpoint.getAddress();
        }

        @Override
        public String getPath() {
            return this.endpoint.getEndpointURI().getPath();
        }

        @Override
        public String getScheme() {
            return this.endpoint.getEndpointURI().getScheme();
        }
    }

    private static interface IMessageSource {
        public String getAddress();

        public String getPath();

        public String getScheme();
    }
}

