/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.odata.util;

import java.math.BigDecimal;
import org.joda.time.DateTime;
import org.json.JSONObject;
import org.mule.module.apikit.odata.util.DateParser;
import org.odata4j.core.OProperties;
import org.odata4j.core.OProperty;
import org.odata4j.core.UnsignedByte;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.edm.EdmType;

public class EDMTypeConverter {
    public static final String EDM_STRING = "Edm.String";
    public static final String EDM_DATETIME = "Edm.DateTime";
    public static final String EDM_BOOLEAN = "Edm.Boolean";
    public static final String EDM_DECIMAL = "Edm.Decimal";
    public static final String EDM_DOUBLE = "Edm.Double";
    public static final String EDM_SINGLE = "Edm.Single";
    public static final String EDM_INT16 = "Edm.Int16";
    public static final String EDM_INT32 = "Edm.Int32";
    public static final String EDM_INT64 = "Edm.Int64";
    public static final String EDM_TIME = "Edm.Time";
    public static final String EDM_DATETIMEOFFSET = "Edm.DateTimeOffset";
    public static final String EDM_BINARY = "Edm.Binary";
    public static final String EDM_BYTE = "Edm.Byte";
    public static final String EDM_GUID = "Edm.Guid";
    public static final String EDM_SBYTE = "Edm.SByte";

    public static EdmSimpleType convert(String type) {
        if (EDM_STRING.equals(type)) {
            return EdmSimpleType.STRING;
        }
        if (EDM_DATETIME.equals(type)) {
            return EdmSimpleType.DATETIME;
        }
        if (EDM_BOOLEAN.equals(type)) {
            return EdmSimpleType.BOOLEAN;
        }
        if (EDM_DECIMAL.equals(type)) {
            return EdmSimpleType.DECIMAL;
        }
        if (EDM_DOUBLE.equals(type)) {
            return EdmSimpleType.DOUBLE;
        }
        if (EDM_SINGLE.equals(type)) {
            return EdmSimpleType.SINGLE;
        }
        if (EDM_INT16.equals(type)) {
            return EdmSimpleType.INT16;
        }
        if (EDM_INT32.equals(type)) {
            return EdmSimpleType.INT32;
        }
        if (EDM_INT64.equals(type)) {
            return EdmSimpleType.INT64;
        }
        if (EDM_TIME.equals(type)) {
            return EdmSimpleType.TIME;
        }
        if (EDM_DATETIMEOFFSET.equals(type)) {
            return EdmSimpleType.DATETIMEOFFSET;
        }
        if (EDM_BINARY.equals(type)) {
            return EdmSimpleType.BINARY;
        }
        if (EDM_BYTE.equals(type)) {
            return EdmSimpleType.BYTE;
        }
        if (EDM_GUID.equals(type)) {
            return EdmSimpleType.GUID;
        }
        if (EDM_SBYTE.equals(type)) {
            return EdmSimpleType.SBYTE;
        }
        return EdmSimpleType.STRING;
    }

    public static OProperty getOProperty(String name, Object value, EdmType type) {
        boolean isNotNullValue;
        boolean bl = isNotNullValue = value != null && value != JSONObject.NULL;
        if (EdmSimpleType.INT16.equals((Object)type)) {
            return OProperties.int16((String)name, isNotNullValue ? Short.valueOf(String.valueOf(value)) : null);
        }
        if (EdmSimpleType.INT32.equals((Object)type)) {
            return OProperties.int32((String)name, isNotNullValue ? Integer.valueOf(String.valueOf(value)) : null);
        }
        if (EdmSimpleType.INT64.equals((Object)type)) {
            return OProperties.int64((String)name, isNotNullValue ? Long.valueOf(String.valueOf(value)) : null);
        }
        if (EdmSimpleType.BINARY.equals((Object)type)) {
            return OProperties.binary((String)name, (byte[])(isNotNullValue ? String.valueOf(value).getBytes() : new byte[]{}));
        }
        if (EdmSimpleType.BOOLEAN.equals((Object)type)) {
            return OProperties.boolean_((String)name, isNotNullValue ? Boolean.valueOf(String.valueOf(value)) : null);
        }
        if (EdmSimpleType.BYTE.equals((Object)type)) {
            return OProperties.byte_((String)name, isNotNullValue ? UnsignedByte.parseUnsignedByte((String)String.valueOf(value)) : null);
        }
        if (EdmSimpleType.DATETIME.equals((Object)type)) {
            return OProperties.datetime((String)name, isNotNullValue ? DateParser.parse(String.valueOf(value)) : null);
        }
        if (EdmSimpleType.DATETIMEOFFSET.equals((Object)type)) {
            return OProperties.datetimeOffset((String)name, (DateTime)(isNotNullValue ? new DateTime((Object)DateParser.parse(String.valueOf(value))) : null));
        }
        if (EdmSimpleType.DECIMAL.equals((Object)type)) {
            return OProperties.decimal((String)name, (BigDecimal)(isNotNullValue ? new BigDecimal(String.valueOf(value)) : null));
        }
        if (EdmSimpleType.DOUBLE.equals((Object)type)) {
            return OProperties.double_((String)name, isNotNullValue ? Double.valueOf(String.valueOf(value)) : null);
        }
        if (EdmSimpleType.SINGLE.equals((Object)type)) {
            return OProperties.single((String)name, isNotNullValue ? Float.valueOf(String.valueOf(value)) : null);
        }
        if (EdmSimpleType.SBYTE.equals((Object)type)) {
            return OProperties.sbyte_((String)name, (byte)(isNotNullValue ? Byte.valueOf(String.valueOf(value)) : (byte)0));
        }
        if (EdmSimpleType.TIME.equals((Object)type)) {
            return OProperties.time((String)name, isNotNullValue ? DateParser.parse(String.valueOf(value)) : null);
        }
        return OProperties.string((String)name, (String)(isNotNullValue ? String.valueOf(value) : null));
    }
}

