/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.odata.processor;

import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.extension.http.api.HttpRequestAttributesBuilder;
import org.mule.module.apikit.odata.AbstractRouterInterface;
import org.mule.module.apikit.odata.ODataPayload;
import org.mule.module.apikit.odata.context.OdataContext;
import org.mule.module.apikit.odata.exception.ClientErrorException;
import org.mule.module.apikit.odata.exception.ODataInvalidFlowResponseException;
import org.mule.module.apikit.odata.exception.ODataInvalidUriException;
import org.mule.module.apikit.odata.exception.ODataUnsupportedMediaTypeException;
import org.mule.module.apikit.odata.formatter.ODataApiKitFormatter;
import org.mule.module.apikit.odata.formatter.ODataPayloadFormatter;
import org.mule.module.apikit.odata.metadata.OdataMetadataManager;
import org.mule.module.apikit.odata.metadata.model.entities.EntityDefinition;
import org.mule.module.apikit.odata.metadata.model.entities.EntityDefinitionProperty;
import org.mule.module.apikit.odata.model.Entry;
import org.mule.module.apikit.odata.processor.BodyToJsonConverter;
import org.mule.module.apikit.odata.processor.ODataRequestProcessor;
import org.mule.module.apikit.odata.util.CoreEventUtils;
import org.mule.module.apikit.odata.util.Helper;
import org.mule.module.apikit.odata.util.ODataUriHelper;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.event.CoreEvent;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class ODataApikitProcessor
extends ODataRequestProcessor {
    private static final String[] methodsWithBody = new String[]{"POST", "PUT"};
    public static final String KEY_VALUE_SEPARATOR = "_";
    public static final String KEYS_SEPARATOR = "-";
    public static final String URL_RESOURCE_SEPARATOR = "/";
    private static final String ODATA_PREFIX = "/odata.svc";
    private String path;
    private String query;
    private String entity;
    private boolean entityCount;
    private Map<String, Object> keys;

    public ODataApikitProcessor(OdataContext odataContext, String entity, String query, Map<String, Object> keys, boolean count) throws ODataInvalidUriException {
        super(odataContext);
        this.query = query;
        this.entity = entity;
        this.entityCount = count;
        this.keys = keys;
        this.path = this.generatePath(entity, keys);
    }

    private static int checkResponseHttpStatus(CoreEvent response) throws ClientErrorException {
        String status = ((TypedValue)response.getVariables().get("httpStatus")).getValue().toString();
        int httpStatus = 0;
        try {
            httpStatus = Integer.valueOf(status);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (httpStatus >= 400) {
            String payload = CoreEventUtils.getPayloadAsString(response);
            throw new ClientErrorException(payload != null ? payload.toString() : "", httpStatus);
        }
        return httpStatus;
    }

    private static ODataPayloadFormatter.InlineCount getInlineCountParam(CoreEvent event) {
        HttpRequestAttributes attributes = (HttpRequestAttributes)event.getMessage().getAttributes().getValue();
        if (attributes == null) {
            return ODataPayloadFormatter.InlineCount.NONE;
        }
        MultiMap queryParams = attributes.getQueryParams();
        String inlineCountParameterValue = (String)queryParams.get((Object)"$inlinecount");
        if ("allpages".equalsIgnoreCase(inlineCountParameterValue)) {
            return ODataPayloadFormatter.InlineCount.ALL_PAGES;
        }
        return ODataPayloadFormatter.InlineCount.NONE;
    }

    private String generatePath(String entity, Map<String, Object> keys) throws ODataInvalidUriException {
        String keysPath = URL_RESOURCE_SEPARATOR + entity;
        if (keys.size() == 1) {
            keysPath = keysPath + URL_RESOURCE_SEPARATOR + this.encode(keys.values().iterator().next().toString());
        } else if (keys.size() > 1) {
            Function<Map.Entry, String> parseKey = entry -> (String)entry.getKey() + KEY_VALUE_SEPARATOR + entry.getValue();
            keysPath = keysPath + URL_RESOURCE_SEPARATOR + keys.entrySet().stream().map(parseKey).sorted().collect(Collectors.joining(KEYS_SEPARATOR));
        }
        return keysPath;
    }

    private String encode(String id) throws ODataInvalidUriException {
        try {
            return URLEncoder.encode(id, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new ODataInvalidUriException("Unable to encode entity id");
        }
    }

    @Override
    public Mono<ODataPayload<?>> process(CoreEvent event, AbstractRouterInterface router, List<ODataPayloadFormatter.Format> formats) {
        String oDataCompleteURL = this.getCompleteUrl(CoreEventUtils.getHttpRequestAttributes(event));
        String oDataURL = ODataUriHelper.getOdataUrl(oDataCompleteURL);
        return this.processEntityRequest(event, router, formats).flatMap(oDataPayload -> {
            List entries = (List)oDataPayload.getValue();
            if (!this.isEntityCount()) {
                oDataPayload.setFormatter(new ODataApiKitFormatter(this.getMetadataManager(), this.entity, oDataURL, entries, oDataPayload.getInlineCount(ODataApikitProcessor.getInlineCountParam(event))));
                return Mono.just((Object)oDataPayload);
            }
            if (formats.contains((Object)ODataPayloadFormatter.Format.Plain) || formats.contains((Object)ODataPayloadFormatter.Format.Default)) {
                String count = String.valueOf(entries.size());
                return Mono.just(new ODataPayload<String>(oDataPayload.getMuleEvent(), count, oDataPayload.getStatus()));
            }
            return Mono.error((Throwable)new ODataUnsupportedMediaTypeException("Unsupported media type requested."));
        });
    }

    public Mono<ODataPayload<List<Entry>>> processEntityRequest(CoreEvent event, AbstractRouterInterface router, List<ODataPayloadFormatter.Format> formats) {
        Publisher<CoreEvent> processResponse;
        try {
            Message message;
            HttpRequestAttributes attributes = CoreEventUtils.getHttpRequestAttributes(event);
            HttpRequestAttributes httpRequestAttributes = this.getHttpRequestAttributes(attributes);
            if (Arrays.asList(methodsWithBody).contains(attributes.getMethod().toUpperCase())) {
                String payloadAsString = CoreEventUtils.getPayloadAsString(event);
                if (payloadAsString == null) {
                    payloadAsString = "";
                }
                boolean isXMLFormat = !formats.contains((Object)ODataPayloadFormatter.Format.Json);
                payloadAsString = BodyToJsonConverter.convertPayload(this.entity, isXMLFormat, payloadAsString);
                message = Message.builder().value((Object)payloadAsString).mediaType(MediaType.APPLICATION_JSON).attributesValue((Object)httpRequestAttributes).build();
            } else {
                message = Message.builder((Message)event.getMessage()).attributesValue((Object)httpRequestAttributes).build();
            }
            CoreEvent odataEvent = CoreEvent.builder((CoreEvent)event).message(message).addVariable("odata", (Object)this.getMetadataManager().getOdataContextVariables(this.entity)).build();
            processResponse = router.processEvent(odataEvent);
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
        return Mono.from(processResponse).onErrorMap(error -> new ODataInvalidFlowResponseException(error.getMessage())).flatMap(this::verifyFlowResponse);
    }

    private HttpRequestAttributes getHttpRequestAttributes(HttpRequestAttributes attributes) {
        String uri = attributes.getRawRequestPath();
        String basePath = uri.substring(0, uri.toLowerCase().indexOf(ODATA_PREFIX));
        String httpRequestPath = basePath + this.path;
        String httpRequest = ODataApikitProcessor.concatToPath(httpRequestPath, attributes.getQueryString());
        HttpRequestAttributesBuilder httpRequestAttributesBuilder = new HttpRequestAttributesBuilder();
        httpRequestAttributesBuilder.listenerPath(attributes.getListenerPath());
        httpRequestAttributesBuilder.relativePath(this.path);
        httpRequestAttributesBuilder.version(attributes.getVersion());
        httpRequestAttributesBuilder.scheme(attributes.getScheme());
        httpRequestAttributesBuilder.method(attributes.getMethod());
        httpRequestAttributesBuilder.requestPath(httpRequestPath);
        httpRequestAttributesBuilder.requestUri(httpRequest);
        httpRequestAttributesBuilder.queryString(attributes.getQueryString());
        httpRequestAttributesBuilder.localAddress(attributes.getLocalAddress());
        httpRequestAttributesBuilder.remoteAddress(attributes.getRemoteAddress());
        httpRequestAttributesBuilder.rawRequestUri(ODataApikitProcessor.concatToPath(this.path, ODataApikitProcessor.getRawQueryString(attributes)));
        MultiMap<String, String> httpQueryParams = Helper.replaceQueryParams((MultiMap<String, String>)attributes.getQueryParams());
        httpRequestAttributesBuilder.queryParams(httpQueryParams);
        MultiMap headers = new MultiMap(attributes.getHeaders());
        ODataApikitProcessor.mergeHeader((MultiMap<String, String>)headers, "host", attributes.getRemoteAddress());
        ODataApikitProcessor.mergeHeader((MultiMap<String, String>)headers, "content-type", MediaType.APPLICATION_JSON.toString());
        ODataApikitProcessor.mergeHeader((MultiMap<String, String>)headers, "accept", MediaType.APPLICATION_JSON.toString());
        httpRequestAttributesBuilder.headers(headers);
        return httpRequestAttributesBuilder.build();
    }

    private static String concatToPath(String path, String queryString) {
        StringBuilder stringBuilder = new StringBuilder(path);
        if (queryString != null && !queryString.isEmpty()) {
            stringBuilder.append("?").append(queryString);
        }
        return stringBuilder.toString();
    }

    private static String getRawQueryString(HttpRequestAttributes attributes) {
        int beginIndex = attributes.getRawRequestUri().indexOf("?");
        return beginIndex != -1 ? attributes.getRawRequestUri().substring(beginIndex + 1) : null;
    }

    private static void mergeHeader(MultiMap<String, String> multiMap, String key, String value) {
        String currentValue = (String)multiMap.get((Object)key);
        if (currentValue != null) {
            multiMap.remove((Object)key);
        }
        multiMap.put((Object)key, (Object)value);
    }

    private Mono<ODataPayload<List<Entry>>> verifyFlowResponse(CoreEvent event) {
        try {
            int httpStatus = ODataApikitProcessor.checkResponseHttpStatus(event);
            OdataMetadataManager metadataManager = this.getMetadataManager();
            EntityDefinition entityDefinition = metadataManager.getEntityByName(this.entity);
            String payload = CoreEventUtils.getPayloadAsString(event);
            List<Entry> entries = Strings.isNullOrEmpty((String)payload) ? new ArrayList<Entry>() : Helper.transformJsonToEntryList(payload);
            int entryNumber = 1;
            for (Entry entry : entries) {
                if (entry.getProperties().entrySet().size() > entityDefinition.getProperties().size()) {
                    throw new ODataInvalidFlowResponseException("There are absent properties in flow response (entry #" + entryNumber + ")");
                }
                for (String propertyName : entry.getProperties().keySet()) {
                    EntityDefinitionProperty entityDefinitionProperty = entityDefinition.findPropertyDefinition(propertyName);
                    if (entityDefinitionProperty != null) continue;
                    throw new ODataInvalidFlowResponseException("Property '" + propertyName + "' was not expected for entity '" + entityDefinition.getName() + "'");
                }
                ++entryNumber;
            }
            return Mono.just(new ODataPayload<List<Entry>>(event, entries, httpStatus));
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public boolean isEntityCount() {
        return this.entityCount;
    }

    public Map<String, Object> getKeys() {
        return this.keys;
    }

    public void setKeys(Map<String, Object> keys) {
        this.keys = keys;
    }
}

