/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.odata;

import org.mule.module.apikit.api.exception.ApikitRuntimeException;
import org.mule.module.apikit.api.spi.AbstractRouter;
import org.mule.module.apikit.api.spi.RouterService;
import org.mule.module.apikit.api.spi.RouterServiceV2;
import org.mule.module.apikit.odata.AbstractODataRouterService;
import org.mule.module.apikit.odata.context.OdataContext;
import org.mule.module.apikit.odata.metadata.OdataMetadataManagerImpl;
import org.mule.module.apikit.odata.metadata.exception.OdataMetadataFormatException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.event.CoreEvent;
import org.reactivestreams.Publisher;

public class ODataRouterService
extends AbstractODataRouterService
implements RouterService,
RouterServiceV2 {
    private OdataContext oDataContext;

    public RouterServiceV2 initialise(String filePath, Scheduler scheduler) {
        this.oDataContext = this.initialiseContext(filePath, scheduler);
        return this;
    }

    public RouterService initialise(String filePath) {
        this.oDataContext = this.initialiseContext(filePath, null);
        return this;
    }

    private OdataContext initialiseContext(String filePath, Scheduler scheduler) {
        try {
            return new OdataContext(new OdataMetadataManagerImpl(filePath, scheduler));
        }
        catch (OdataMetadataFormatException e) {
            throw new ApikitRuntimeException((Throwable)e);
        }
    }

    public Publisher<CoreEvent> process(CoreEvent event, AbstractRouter router) throws MuleException {
        return this.process(event, arg_0 -> ((AbstractRouter)router).processEvent(arg_0));
    }

    @Override
    protected OdataContext geODataContext() {
        return this.oDataContext;
    }
}

