/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.model;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.Version;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.mule.module.apikit.model.Entity;
import org.mule.module.apikit.model.EntityModelParser;
import org.mule.module.apikit.model.exception.EntityModelParsingException;

public class RamlGenerator {
    private static Configuration fmkCfg;

    private static Configuration getConfiguration() {
        if (fmkCfg == null) {
            fmkCfg = new Configuration();
            fmkCfg.setClassForTemplateLoading(RamlGenerator.class, "/");
            fmkCfg.setIncompatibleImprovements(new Version(2, 3, 20));
            fmkCfg.setDefaultEncoding("UTF-8");
            fmkCfg.setLocale(Locale.US);
            fmkCfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        }
        return fmkCfg;
    }

    public String generate(String filePath) throws IOException, TemplateException, EntityModelParsingException {
        return this.generate(EntityModelParser.getEntities(filePath));
    }

    private String generate(List<Entity> entities) throws IOException, TemplateException {
        HashMap<String, Object> raml = new HashMap<String, Object>();
        Configuration cfg = RamlGenerator.getConfiguration();
        raml.put("title", "Auto-generated RAML");
        raml.put("version", "0.1");
        raml.put("ramlVersion", "1.0");
        ArrayList resources = new ArrayList();
        for (Entity entity : entities) {
            HashMap<String, String> resource = new HashMap<String, String>();
            resource.put("name", entity.getName());
            resource.put("elementName", entity.getElementName());
            resource.put("collectionName", entity.getCollectionName());
            resource.put("id", this.buildKeyForResource(entity));
            resources.add(resource);
        }
        raml.put("resources", resources);
        Template template = cfg.getTemplate("api-raml-template.ftl");
        StringWriter out = new StringWriter();
        template.process(raml, (Writer)out);
        return ((Object)out).toString();
    }

    private String buildKeyForResource(Entity entity) {
        List<String> keys = entity.getKeys();
        String ret = "";
        String delim = "";
        if (keys.size() > 1) {
            for (int i = 0; i < keys.size(); ++i) {
                String key = keys.get(i);
                ret = ret + delim;
                ret = ret + key + "_{" + key + "}";
                delim = "-";
            }
        } else {
            ret = "{" + keys.get(0) + "}";
        }
        return ret;
    }
}

