/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.model;

import amf.apicontract.client.platform.AMFBaseUnitClient;
import amf.apicontract.client.platform.AMFConfiguration;
import amf.apicontract.client.platform.AMFLibraryResult;
import amf.apicontract.client.platform.APIConfiguration;
import amf.core.client.common.transform.PipelineId;
import amf.core.client.platform.AMFParseResult;
import amf.core.client.platform.AMFResult;
import amf.core.client.platform.execution.BaseExecutionEnvironment;
import amf.core.client.platform.execution.ExecutionEnvironment;
import amf.core.client.platform.model.document.BaseUnit;
import amf.core.client.platform.model.document.Document;
import amf.core.client.platform.model.document.Module;
import amf.core.client.platform.model.domain.DomainElement;
import amf.core.client.platform.model.domain.DomainExtension;
import amf.core.client.platform.model.domain.PropertyShape;
import amf.core.client.platform.model.domain.ScalarNode;
import amf.core.client.platform.model.domain.Shape;
import amf.core.client.platform.validation.AMFValidationResult;
import amf.core.internal.remote.Spec;
import amf.shapes.client.platform.model.domain.FileShape;
import amf.shapes.client.platform.model.domain.NodeShape;
import amf.shapes.client.platform.model.domain.ScalarShape;
import amf.shapes.client.platform.model.domain.UnionShape;
import com.google.common.base.Strings;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;
import org.mule.module.apikit.odata.metadata.exception.OdataMetadataFieldsException;
import org.mule.module.apikit.odata.metadata.exception.OdataMetadataFormatException;
import org.mule.module.apikit.odata.metadata.model.entities.EntityDefinition;
import org.mule.module.apikit.odata.metadata.model.entities.EntityDefinitionProperty;
import org.mule.module.apikit.odata.metadata.model.entities.EntityDefinitionSet;
import org.mule.module.apikit.odata.metadata.raml.RamlParser;
import org.mule.runtime.api.scheduler.Scheduler;

public class AMFWrapper {
    private final Map<String, CheckedFunction<ScalarShape, String>> typesMapping = this.initialiseTypeMapping();
    private static final String AMF_STRING = "http://www.w3.org/2001/XMLSchema#string";
    private static final String AMF_BOOLEAN = "http://www.w3.org/2001/XMLSchema#boolean";
    private static final String AMF_NUMBER = "http://a.ml/vocabularies/shapes#number";
    private static final String AMF_FLOAT = "http://www.w3.org/2001/XMLSchema#float";
    private static final String AMF_DATE_TIME_ONLY = "http://a.ml/vocabularies/shapes#dateTimeOnly";
    private static final String AMF_INTEGER = "http://www.w3.org/2001/XMLSchema#integer";
    private static final String AMF_TIME = "http://www.w3.org/2001/XMLSchema#time";
    private static final String AMF_DATE_TIME = "http://www.w3.org/2001/XMLSchema#dateTime";
    private static final String AMF_DATE_ONLY = "http://www.w3.org/2001/XMLSchema#date";
    private static final String AMF_LONG = "http://www.w3.org/2001/XMLSchema#long";
    private static final String EDM_TIME_PATTERN = "^PT([0-1]?[0-9]|2[0-3])H[0-5][0-9]M(|[0-5][0-9]S)$";
    private List<NodeShape> nodeShapesList = new ArrayList<NodeShape>();
    private EntityDefinitionSet entityDefinitionSet = new EntityDefinitionSet();

    public AMFWrapper(String ramlPath, Scheduler scheduler) throws OdataMetadataFormatException, OdataMetadataFieldsException {
        ExecutionEnvironment executionEnvironment = scheduler != null ? new ExecutionEnvironment((ScheduledExecutorService)scheduler) : new ExecutionEnvironment();
        this.tryParse(ramlPath, executionEnvironment);
        for (NodeShape nodeShape : this.nodeShapesList) {
            this.entityDefinitionSet.addEntity(this.buildEntityDefinition(nodeShape));
        }
    }

    public AMFWrapper(String ramlPath) throws OdataMetadataFormatException, OdataMetadataFieldsException {
        this(ramlPath, null);
    }

    private void validateODataRAML(AMFResult result) throws OdataMetadataFieldsException {
        List validationResults = result.results();
        if (validationResults.isEmpty()) {
            return;
        }
        String errorMessage = "Parse of odata.raml file failed: ";
        for (AMFValidationResult validationResult : validationResults) {
            errorMessage = errorMessage.concat(validationResult.message() + "\n");
        }
        throw new OdataMetadataFieldsException(errorMessage);
    }

    private void tryParse(String ramlPath, ExecutionEnvironment environment) throws OdataMetadataFieldsException, OdataMetadataFormatException {
        AMFConfiguration amfConfiguration = APIConfiguration.API().withExecutionEnvironment((BaseExecutionEnvironment)environment);
        this.tryParseAsLibrary(amfConfiguration, URLDecoder.decode(ramlPath), environment);
        if (this.nodeShapesList.isEmpty()) {
            throw new OdataMetadataFieldsException("odata.raml must declare at least one type");
        }
    }

    private void tryParseAsLibrary(AMFConfiguration amfConfiguration, String path, ExecutionEnvironment environment) throws OdataMetadataFormatException, OdataMetadataFieldsException {
        try {
            AMFLibraryResult result = (AMFLibraryResult)amfConfiguration.baseUnitClient().parseLibrary(URLDecoder.decode(path)).get();
            this.validateODataRAML((AMFResult)result);
            this.addNodeShapes(result.library(), true);
        }
        catch (InterruptedException | ExecutionException e) {
            this.tryParseAsAPISpec(amfConfiguration, path, environment);
        }
    }

    private void tryParseAsAPISpec(AMFConfiguration amfConfiguration, String path, ExecutionEnvironment environment) throws OdataMetadataFormatException, OdataMetadataFieldsException {
        try {
            AMFParseResult result = (AMFParseResult)amfConfiguration.baseUnitClient().parse(URLDecoder.decode(path)).get();
            amfConfiguration = APIConfiguration.fromSpec((Spec)result.sourceSpec()).withExecutionEnvironment((BaseExecutionEnvironment)environment);
            AMFBaseUnitClient client = amfConfiguration.baseUnitClient();
            AMFResult transformResult = client.transform(result.baseUnit(), PipelineId.Editing());
            this.validateODataRAML(transformResult);
            Document document = (Document)result.baseUnit();
            for (BaseUnit baseUnit : document.references()) {
                if (!(baseUnit instanceof Module)) continue;
                this.addNodeShapes((Module)baseUnit, false);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new OdataMetadataFormatException("odata.raml must declare at least one type");
        }
    }

    private void addNodeShapes(Module module, boolean throwException) throws OdataMetadataFormatException, OdataMetadataFieldsException {
        for (DomainElement domainElement : module.declares()) {
            if (!(domainElement instanceof Shape)) continue;
            String remoteName = this.getAnnotation((Shape)domainElement, RamlParser.NAMESPACE_REMOTE_NAME);
            if (domainElement instanceof NodeShape) {
                NodeShape nodeShape = (NodeShape)domainElement;
                if (remoteName != null) {
                    this.nodeShapesList.add(nodeShape);
                    continue;
                }
                if (!throwException) continue;
                throw new OdataMetadataFieldsException("Property \"remote name\" is missing in entity " + nodeShape.name());
            }
            if (remoteName == null) continue;
            throw new OdataMetadataFormatException("Type not supported. " + remoteName);
        }
    }

    public EntityDefinitionSet getSchemas() {
        return this.entityDefinitionSet;
    }

    private EntityDefinition buildEntityDefinition(NodeShape nodeShape) throws OdataMetadataFormatException, OdataMetadataFieldsException {
        if (nodeShape.properties().isEmpty()) {
            throw new OdataMetadataFormatException("No schemas found.");
        }
        String entityName = nodeShape.name().value();
        String remoteName = this.getAnnotation((Shape)nodeShape, RamlParser.NAMESPACE_REMOTE_NAME);
        EntityDefinition entityDefinition = new EntityDefinition(entityName, remoteName);
        for (PropertyShape propertyShape : nodeShape.properties()) {
            String defaultValue;
            Shape shape = this.getScalarShape(propertyShape.range());
            String propertyName = propertyShape.name().value();
            this.notNull("Property \"name\" is missing in field \"" + propertyName + "\" in entity \"" + entityName + "\"", entityName);
            this.notNull("Property \"remote name\" is missing in field \"" + propertyName + "\" in entity \"" + entityName + "\"", remoteName);
            EntityDefinitionProperty entityDefinitionProperty = null;
            String key = this.getAnnotation(shape, RamlParser.NAMESPACE_KEY_PROPERTY);
            this.notNull("Property \"key\" is missing in field \"" + propertyName + "\" in entity \"" + entityName + "\"", key);
            boolean isKey = Boolean.valueOf(key);
            String nullable = this.getAnnotation(shape, RamlParser.NAMESPACE_NULLABLE_PROPERTY);
            this.notNull("Property \"nullable\" is missing in field \"" + propertyName + "\" in entity \"" + entityName + "\"", nullable);
            boolean isNullable = Boolean.valueOf(nullable);
            String string = defaultValue = propertyShape.defaultValue() != null ? propertyShape.defaultValue().name().value() : null;
            if (shape instanceof ScalarShape) {
                ScalarShape scalarShape = (ScalarShape)shape;
                String type = this.getODataType(scalarShape);
                this.notNull("Property \"type\" is missing in field \"" + propertyName + "\" in entity \"" + entityName + "\"", type);
                String maxLength = null;
                if ("Edm.String".equals(type)) {
                    Integer maxLengthInt = scalarShape.maxLength().value();
                    maxLength = maxLengthInt != 0 ? String.valueOf(maxLengthInt) : null;
                }
                String precision = this.getAnnotation((Shape)scalarShape, RamlParser.NAMESPACE_PRECISION_PROPERTY);
                String scale = this.getAnnotation((Shape)scalarShape, RamlParser.NAMESPACE_SCALE_PROPERTY);
                entityDefinitionProperty = new EntityDefinitionProperty(propertyName, type, isNullable, isKey, defaultValue, maxLength, false, null, false, precision, scale);
            } else if (shape instanceof FileShape) {
                entityDefinitionProperty = new EntityDefinitionProperty(propertyName, "Edm.Binary", isNullable, isKey, defaultValue, null, false, null, false, null, null);
            } else {
                throw new OdataMetadataFieldsException("Type not supported of property " + propertyName);
            }
            entityDefinition.addProperty(entityDefinitionProperty);
            if (entityDefinition.hasPrimaryKey() || !entityDefinitionProperty.isKey()) continue;
            entityDefinition.setHasPrimaryKey(true);
        }
        if (!entityDefinition.hasPrimaryKey()) {
            throw new OdataMetadataFieldsException("Entity defition must have a primary key.");
        }
        return entityDefinition;
    }

    private String getODataType(ScalarShape scalarShape) throws OdataMetadataFieldsException {
        String dataType = scalarShape.dataType().value();
        if (!this.typesMapping.containsKey(dataType)) {
            throw new UnsupportedOperationException("Type not supported " + dataType + " of property " + scalarShape.name());
        }
        return this.typesMapping.get(dataType).apply(scalarShape);
    }

    private Shape getScalarShape(Shape shape) throws OdataMetadataFieldsException {
        if (shape instanceof UnionShape) {
            UnionShape unionShape = (UnionShape)shape;
            List annotations = shape.customDomainProperties();
            for (Shape unionSubShape : unionShape.anyOf()) {
                if (!(unionSubShape instanceof ScalarShape)) continue;
                unionSubShape.withCustomDomainProperties(annotations);
                return unionSubShape;
            }
            throw new OdataMetadataFieldsException(String.format("Property %s cannot be just null.", shape.name()));
        }
        return shape;
    }

    private String getNumberType(ScalarShape scalarShape) throws OdataMetadataFieldsException {
        String format = scalarShape.format().value();
        if (format != null) {
            switch (format) {
                case "int64": {
                    return "Edm.Int64";
                }
                case "int32": {
                    return "Edm.Int32";
                }
                case "int16": {
                    return "Edm.Int16";
                }
                case "int8": {
                    return "Edm.Byte";
                }
            }
            throw new OdataMetadataFieldsException(String.format("Unexpected format %s for number type.", format));
        }
        if (scalarShape.dataType().value().equals(AMF_INTEGER)) {
            return "Edm.Int32";
        }
        String scale = this.getAnnotation((Shape)scalarShape, RamlParser.NAMESPACE_SCALE_PROPERTY);
        String precision = this.getAnnotation((Shape)scalarShape, RamlParser.NAMESPACE_PRECISION_PROPERTY);
        if (scale != null && precision != null) {
            return "Edm.Decimal";
        }
        return "Edm.Double";
    }

    private String getStringType(ScalarShape scalarShape) {
        String subType = this.getAnnotation((Shape)scalarShape, RamlParser.NAMESPACE_TYPE_PROPERTY);
        if ("guid".equals(subType)) {
            return "Edm.Guid";
        }
        if (scalarShape.pattern() != null && EDM_TIME_PATTERN.equals(scalarShape.pattern().toString())) {
            return "Edm.Time";
        }
        return "Edm.String";
    }

    private void notNull(String message, Object actual) throws OdataMetadataFieldsException {
        if (actual == null || Strings.isNullOrEmpty((String)actual.toString())) {
            throw new OdataMetadataFieldsException(message);
        }
    }

    @Nullable
    private String getAnnotation(Shape nodeShape, String annotationName) {
        for (DomainExtension annotation : nodeShape.customDomainProperties()) {
            if (!annotationName.equals(annotation.name().value())) continue;
            return ((ScalarNode)annotation.extension()).value().value();
        }
        return null;
    }

    private Map<String, CheckedFunction<ScalarShape, String>> initialiseTypeMapping() {
        HashMap<String, CheckedFunction<ScalarShape, String>> mapping = new HashMap<String, CheckedFunction<ScalarShape, String>>();
        mapping.put(AMF_BOOLEAN, scalarShape -> "Edm.Boolean");
        mapping.put(AMF_STRING, this::getStringType);
        mapping.put(AMF_FLOAT, scalarShape -> "Edm.Single");
        mapping.put(AMF_DATE_TIME_ONLY, scalarShape -> "Edm.DateTime");
        mapping.put(AMF_NUMBER, this::getNumberType);
        mapping.put(AMF_INTEGER, this::getNumberType);
        mapping.put(AMF_LONG, this::getNumberType);
        mapping.put(AMF_TIME, scalarShape -> "Edm.Time");
        mapping.put(AMF_DATE_TIME, scalarShape -> "Edm.DateTimeOffset");
        mapping.put(AMF_DATE_ONLY, scalarShape -> "Edm.DateTimeOffset");
        return mapping;
    }

    @FunctionalInterface
    private static interface CheckedFunction<T, R> {
        public R apply(T var1) throws OdataMetadataFieldsException;
    }
}

